/*
 * Decompiled with CFR 0.152.
 */
package com.scene;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.home.Home;
import com.scene.GameObject;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Scene {
    private static final int GRAVITATION = -5;
    private Home home;
    private Vector activeObjects = new Vector();
    private int frame = 0;
    public GameObject cam = null;

    public Scene(Home home) {
        this.home = home;
    }

    public void drawDebug(Graphics3D graphics3D, Graphics graphics, int n, int n2) {
        this.home.drawDebug(graphics3D, graphics, n, n2);
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            GameObject gameObject = (GameObject)this.activeObjects.elementAt(i);
            gameObject.paintDebug(graphics3D, graphics, n, n2);
        }
    }

    public int render(Graphics3D graphics3D, int n) {
        return this.home.render(graphics3D, n);
    }

    public int render(Graphics3D graphics3D) {
        return this.home.render(graphics3D, this.cam.getPart());
    }

    public void update(int n) {
        GameObject gameObject;
        int n2;
        this.home.getActiveObjects(this.activeObjects, n);
        for (n2 = 0; n2 < this.activeObjects.size(); ++n2) {
            gameObject = (GameObject)this.activeObjects.elementAt(n2);
            gameObject.update(this);
        }
        for (n2 = 0; n2 < this.activeObjects.size(); ++n2) {
            gameObject = (GameObject)this.activeObjects.elementAt(n2);
            for (int i = n2 + 1; i < this.activeObjects.size(); ++i) {
                GameObject gameObject2 = (GameObject)this.activeObjects.elementAt(i);
                gameObject.collisionTest(gameObject2);
            }
        }
        for (n2 = 0; n2 < this.activeObjects.size(); ++n2) {
            gameObject = (GameObject)this.activeObjects.elementAt(n2);
            gameObject.collisionTest(this.home);
            this.home.recomputePart(gameObject);
        }
        ++this.frame;
    }

    public void update(GameObject gameObject) {
        gameObject.update(this);
        ++this.frame;
    }

    public GameObject addGameObject(GameObject gameObject) {
        this.home.addObject(gameObject);
        return gameObject;
    }

    public void setCamera(GameObject gameObject) {
        this.cam = gameObject;
    }

    public GameObject getCamera() {
        return this.cam;
    }

    public void removeGameObject(GameObject gameObject) {
        this.home.removeObject(gameObject);
    }

    public GameObject find(Class clazz) {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            Object e = this.activeObjects.elementAt(i);
            if (e.getClass() != clazz) continue;
            return (GameObject)e;
        }
        return null;
    }

    public Vector getActiveObjects() {
        return this.activeObjects;
    }

    public int getActiveObjectsCount() {
        return this.activeObjects.size();
    }

    public GameObject getActiveObject(int n) {
        return (GameObject)this.activeObjects.elementAt(n);
    }

    public int getGravitation() {
        return -5;
    }

    public int getFrame() {
        return this.frame;
    }

    public boolean isOpenSky() {
        return this.home.isOpenSky();
    }

    public void applyCam(Graphics3D graphics3D) {
        if (this.cam != null) {
            graphics3D.getCamera().set(this.cam.getTransform());
            graphics3D.setCamera(graphics3D.getCamera());
        }
    }

    public void applyCam(Graphics3D graphics3D, int n) {
        if (this.cam != null) {
            graphics3D.getCamera().set(this.cam.getTransform());
            graphics3D.getCamera().m13 += n;
            graphics3D.setCamera(graphics3D.getCamera());
        }
    }
}

