/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Vertex;

public class Morphing {
    public static final int fp = 10;
    public static final int FP = 1024;
    private short[][] animation;
    private int frame = 0;

    public static Morphing create(Mesh[] meshArray) {
        short[][] sArrayArray = new short[meshArray.length][];
        for (int i = 0; i < meshArray.length; ++i) {
            sArrayArray[i] = Morphing.verticesToArray(meshArray[i].getVertices());
        }
        Morphing morphing = new Morphing();
        morphing.animation = sArrayArray;
        return morphing;
    }

    private static short[] verticesToArray(Vertex[] vertexArray) {
        short[] sArray = new short[vertexArray.length * 3];
        for (int i = 0; i < vertexArray.length; ++i) {
            Vertex vertex = vertexArray[i];
            sArray[3 * i] = (short)vertex.x;
            sArray[3 * i + 1] = (short)vertex.y;
            sArray[3 * i + 2] = (short)vertex.z;
        }
        return sArray;
    }

    private Morphing() {
    }

    public Morphing(Morphing morphing) {
        this.animation = morphing.animation;
    }

    public int getNumFrames() {
        return this.animation.length * 1024;
    }

    public void addFrame(int n) {
        this.setFrame(this.frame + n);
    }

    public void setFrame(int n) {
        int n2 = this.getNumFrames();
        while (n < 0) {
            n += n2;
        }
        this.frame = n %= n2;
    }

    public int getFrame() {
        return this.frame;
    }

    void interpolation(Vertex[] vertexArray) {
        int n = this.frame / 1024;
        int n2 = n % this.animation.length;
        int n3 = (n + 1) % this.animation.length;
        this.interpolation(this.animation[n2], this.animation[n3], vertexArray, this.frame % 1024);
    }

    private void interpolation(short[] sArray, short[] sArray2, Vertex[] vertexArray, int n) {
        int n2 = 1024 - n;
        for (int i = 0; i < vertexArray.length; ++i) {
            int n3 = i * 3;
            short s = sArray[n3];
            short s2 = sArray[n3 + 1];
            short s3 = sArray[n3 + 2];
            short s4 = sArray2[n3];
            short s5 = sArray2[n3 + 1];
            short s6 = sArray2[n3 + 2];
            vertexArray[i].set((s * n2 >> 10) + (s4 * n >> 10), (s2 * n2 >> 10) + (s5 * n >> 10), (s3 * n2 >> 10) + (s6 * n >> 10));
        }
    }

    public short[][] getVertices() {
        return this.animation;
    }
}

