/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.mycanvas;

import com.gameutils.mycanvas.Keyboard;
import com.gameutils.mycanvas.MyCanvas;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class MainCanvas
extends Canvas {
    private static MainCanvas mainCanvas;
    private Keyboard keyboard;
    private MyCanvas screen;
    private boolean hasScreen = false;

    public MainCanvas(MIDlet mIDlet) {
        this.setFullScreenMode(true);
        mainCanvas = this;
        this.keyboard = new Keyboard(this);
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)this);
    }

    public void setScreen(MyCanvas myCanvas) {
        if (this.screen != null) {
            this.screen.hideNotify();
        }
        this.screen = myCanvas;
        this.hasScreen = myCanvas != null;
        this.screen.showNotify();
    }

    static Keyboard getKeyboard() {
        return MainCanvas.mainCanvas.keyboard;
    }

    static int getMainWidth() {
        return mainCanvas.getWidth();
    }

    static int getMainHeight() {
        return mainCanvas.getHeight();
    }

    static void mainRepaint(MyCanvas myCanvas) {
        if (MainCanvas.mainCanvas.screen == myCanvas) {
            mainCanvas.repaint();
        }
    }

    static void mainRepaint(MyCanvas myCanvas, int n, int n2, int n3, int n4) {
        if (MainCanvas.mainCanvas.screen == myCanvas) {
            mainCanvas.repaint(n, n2, n3, n4);
        }
    }

    static void mainServiceRepaints(MyCanvas myCanvas) {
        if (MainCanvas.mainCanvas.screen == myCanvas) {
            mainCanvas.serviceRepaints();
        }
    }

    protected void paint(Graphics graphics) {
        if (this.hasScreen) {
            this.screen.paint(graphics);
        }
    }

    protected void keyPressed(int n) {
        this.keyboard.keyPressed(n);
        if (this.hasScreen) {
            this.screen.keyPressed(n);
        }
    }

    protected void keyRepeated(int n) {
        if (this.hasScreen) {
            this.screen.keyRepeated(n);
        }
    }

    protected void keyReleased(int n) {
        this.keyboard.keyReleased(n);
        if (this.hasScreen) {
            this.screen.keyReleased(n);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (this.hasScreen) {
            this.screen.pointerPressed(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (this.hasScreen) {
            this.screen.pointerReleased(n, n2);
        }
    }

    protected void pointerDragged(int n, int n2) {
        if (this.hasScreen) {
            this.screen.pointerDragged(n, n2);
        }
    }
}

