/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.gui;

import com.gameutils.gui.MyFont;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TextView {
    private static final int INDENT = 3;
    private Vector lines = new Vector();
    private MyFont font;
    private int w;
    private int h;
    private boolean center = false;
    private int yOffset = 0;

    public TextView(String string, int n, int n2, MyFont myFont) {
        this.font = myFont;
        this.w = n;
        this.h = n2;
        this.createLines(string, this.lines);
    }

    private void createLines(String string, Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == ' ') {
                n3 = n4;
            }
            int n5 = -1;
            if (c == '\n') {
                n5 = n4++;
            } else if (n + this.font.charWidth(c) > this.w) {
                if (n3 != -1) {
                    n4 = n3 + 1;
                    n5 = n3;
                } else {
                    n5 = n4;
                }
            }
            if (n5 != -1) {
                String string2 = string.substring(n2, n5);
                vector.addElement(string2);
                n = 0;
                n2 = n4;
                continue;
            }
            n += this.font.charWidth(c);
            ++n4;
        }
        if (n2 < string.length()) {
            vector.addElement(string.substring(n2, string.length()));
        }
    }

    public void addString(String string) {
        this.createLines(string, this.lines);
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        graphics.setClip(n, n2, this.w, this.h);
        int n7 = this.getLineHeight();
        int n8 = this.yOffset;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (n8 + n7 >= 0) {
                int n9;
                if (n8 > this.h) break;
                String string = (String)this.lines.elementAt(i);
                n9 = this.center ? (n9 = this.w - this.font.stringWidth(string) >> 1) : 0;
                this.font.drawString(graphics, string, n9 + n, n8 + n2, 0);
            }
            n8 += n7;
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    public void move(int n) {
        this.yOffset += n;
        int n2 = this.getTextHeight();
        if (n2 > this.h) {
            if (this.yOffset > 0) {
                this.yOffset = 0;
            }
            if (this.yOffset + n2 < this.h) {
                this.yOffset = this.h - n2;
            }
        } else {
            if (this.yOffset < 0) {
                this.yOffset = 0;
            }
            if (this.yOffset + n2 > this.h) {
                this.yOffset = this.h - n2;
            }
        }
    }

    public MyFont getFont() {
        return this.font;
    }

    public int getCountString() {
        return this.lines.size();
    }

    public int getLineHeight() {
        return this.font.getHeight() + 3;
    }

    public int getTextHeight() {
        return this.getLineHeight() * this.lines.size() - 3;
    }

    public int getY() {
        return this.yOffset;
    }

    public void setY(int n) {
        this.yOffset = n;
    }

    public boolean getCenter() {
        return this.center;
    }

    public void setCenter(boolean bl) {
        this.center = bl;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }
}

