/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.gui;

import com.gameutils.textutils.StringStore;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyFont {
    private int space;
    private Image image;
    private int[] coords;
    private char[] chars;

    public static MyFont createFromFromResource(String string) throws IOException {
        StringStore stringStore = StringStore.createFromFromResource(string);
        Image image = Image.createImage((String)stringStore.get("IMG"));
        char[] cArray = stringStore.get("CHARS").toCharArray();
        return new MyFont(image, cArray);
    }

    public MyFont(Image image, char[] cArray) {
        int n;
        this.chars = cArray;
        this.image = Image.createImage((Image)image, (int)0, (int)1, (int)image.getWidth(), (int)(image.getHeight() - 1), (int)0);
        int[] nArray = new int[image.getWidth()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), 1);
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(0));
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            if (n2 != -16777216) continue;
            vector.addElement(new Integer(n));
        }
        vector.addElement(new Integer(this.image.getWidth()));
        this.coords = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.coords[n] = (Integer)vector.elementAt(n);
        }
        this.space = 0;
        for (n = 0; n < cArray.length; ++n) {
            this.space += this.charWidth(cArray[n]);
        }
        this.space /= cArray.length;
    }

    public int getCode(char c) {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        this.drawSubstring(graphics, string, 0, string.length(), n, n2, n3);
    }

    public void drawSubstring(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3;
        int n7 = n4;
        if ((n5 & 4) != 0) {
            // empty if block
        }
        if ((n5 & 8) != 0) {
            n6 -= this.stringWidth(string);
        }
        if ((n5 & 0x10) != 0) {
            // empty if block
        }
        if ((n5 & 0x20) != 0) {
            n7 -= this.getHeight();
        }
        if ((n5 & 1) != 0) {
            n6 -= this.stringWidth(string) >> 1;
        }
        if ((n5 & 2) != 0) {
            n7 -= this.getHeight() >> 1;
        }
        if ((n5 & 0x40) != 0) {
            n7 -= this.getHeight() + 1;
        }
        this.drawSubstring(graphics, string, n, n2, n6, n7);
    }

    private void drawSubstring(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = this.image.getHeight();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                n3 += this.space;
                continue;
            }
            int n6 = this.getCode(c);
            if (n6 == -1) {
                graphics.setColor(-1);
                graphics.drawRect(n3, n4, this.space - 1, n5);
                n3 += this.space;
                continue;
            }
            int n7 = this.coords[n6];
            int n8 = this.coords[n6 + 1] - n7;
            graphics.drawRegion(this.image, n7, 0, n8, n5, 0, n3, n4, 0);
            n3 += n8;
        }
    }

    public int charWidth(char c) {
        if (c == ' ') {
            return this.space;
        }
        int n = this.getCode(c);
        if (n == -1) {
            return this.space;
        }
        int n2 = this.coords[n];
        int n3 = this.coords[n + 1];
        return n3 - n2;
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int stringWidth(String string) {
        return this.substringWidth(string, 0, string.length());
    }

    public int substringWidth(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += this.charWidth(string.charAt(i));
        }
        return n3;
    }
}

