/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.input;

import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Vertex;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Loader3D {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mesh[] loadMeshes(String string, float f, float f2, float f3) {
        Mesh[] meshArray = null;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = new Object().getClass().getResourceAsStream(string);
            filterInputStream = new DataInputStream(inputStream);
            meshArray = Loader3D.loadMeshes((DataInputStream)filterInputStream, f, f2, f3, string);
        }
        catch (Exception exception) {
            System.err.println("ERROR in Loader.loadMeshes: " + exception);
        }
        finally {
            try {
                filterInputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return meshArray;
    }

    private static Mesh[] loadMeshes(DataInputStream dataInputStream, float f, float f2, float f3, String string) throws IOException {
        int n = dataInputStream.readInt();
        Mesh[] meshArray = new Mesh[n];
        for (int i = 0; i < meshArray.length; ++i) {
            String string2 = string;
            if (meshArray.length > 1) {
                string2 = string2 + " (" + (i + 1) + "/" + meshArray.length + ")";
            }
            meshArray[i] = Loader3D.loadMesh(string2, dataInputStream, f, f2, f3);
        }
        return meshArray;
    }

    private static Mesh loadMesh(String string, DataInputStream dataInputStream, float f, float f2, float f3) throws IOException {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n;
        int n2;
        int n3;
        int n4;
        Vertex[] vertexArray = new Vertex[dataInputStream.readShort()];
        short s = 0;
        for (int i = 0; i < vertexArray.length; ++i) {
            n4 = (int)((float)dataInputStream.readShort() * f);
            n3 = (int)((float)dataInputStream.readShort() * f2);
            n2 = (int)((float)dataInputStream.readShort() * f3);
            vertexArray[i] = new Vertex(n4, n3, n2);
        }
        Polygon3V[] polygon3VArray = new Polygon3V[dataInputStream.readShort()];
        for (n4 = 0; n4 < polygon3VArray.length; ++n4) {
            n3 = dataInputStream.readShort();
            if (n3 == Short.MIN_VALUE) {
                s = dataInputStream.readShort();
                n3 = dataInputStream.readShort();
            }
            n2 = dataInputStream.readShort();
            n = dataInputStream.readShort();
            byte by6 = dataInputStream.readByte();
            byte by5 = dataInputStream.readByte();
            by4 = dataInputStream.readByte();
            by3 = dataInputStream.readByte();
            by2 = dataInputStream.readByte();
            by = dataInputStream.readByte();
            Vertex vertex = vertexArray[n3];
            Vertex vertex2 = vertexArray[n2];
            Vertex vertex3 = vertexArray[n];
            polygon3VArray[n4] = new Polygon3V(vertex3, by2, by, vertex2, by4, by3, vertex, by6, by5);
            polygon3VArray[n4].tex = s;
        }
        s = 0;
        Polygon4V[] polygon4VArray = new Polygon4V[dataInputStream.readShort()];
        for (n3 = 0; n3 < polygon4VArray.length; ++n3) {
            n2 = dataInputStream.readShort();
            if (n2 == Short.MIN_VALUE) {
                s = dataInputStream.readShort();
                n2 = dataInputStream.readShort();
            }
            n = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            by4 = dataInputStream.readByte();
            by3 = dataInputStream.readByte();
            by2 = dataInputStream.readByte();
            by = dataInputStream.readByte();
            byte by6 = dataInputStream.readByte();
            byte by7 = dataInputStream.readByte();
            byte by8 = dataInputStream.readByte();
            byte by9 = dataInputStream.readByte();
            Vertex vertex = vertexArray[n2];
            Vertex vertex4 = vertexArray[n];
            Vertex vertex5 = vertexArray[s2];
            Vertex vertex6 = vertexArray[s3];
            polygon4VArray[n3] = new Polygon4V(vertex6, by8, by9, vertex5, by6, by7, vertex4, by2, by, vertex, by4, by3);
            polygon4VArray[n3].tex = s;
        }
        RenderObject[] renderObjectArray = new RenderObject[polygon3VArray.length + polygon4VArray.length];
        n2 = 0;
        for (n = 0; n < polygon3VArray.length; ++n) {
            renderObjectArray[n2] = polygon3VArray[n];
            ++n2;
        }
        for (n = 0; n < polygon4VArray.length; ++n) {
            renderObjectArray[n2] = polygon4VArray[n];
            ++n2;
        }
        System.out.println("Mesh " + string + " \u0420\u0406\u0420\u00b5\u0421\u0402\u0421\u20ac\u0420\u0451\u0420\u0405: " + vertexArray.length + " \u0420\u0457\u0420\u0455\u0420\u00bb\u0420\u0451\u0420\u0456\u0420\u0455\u0420\u0405\u0420\u0455\u0420\u0406: " + renderObjectArray.length);
        return new Mesh(vertexArray, renderObjectArray);
    }
}

