/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.home;

import com.iceberg.collide.Ray;
import com.iceberg.collide.RayCast;
import com.iceberg.collide.SphereCast;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.home.Portal;
import com.iceberg.home.RoomObject;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Vector3D;
import java.util.Vector;

public class Room {
    private final int id;
    private final Mesh mesh;
    private final int minx;
    private final int maxx;
    private final int minz;
    private final int maxz;
    private final boolean openSky;
    private Vector objects = new Vector(0);
    private Portal[] portals;
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    Room(Mesh mesh, int n) {
        this.mesh = mesh;
        this.id = n;
        this.minx = mesh.minX();
        this.maxx = mesh.maxX();
        this.minz = mesh.minZ();
        this.maxz = mesh.maxZ();
        this.openSky = this.openSkyTest();
    }

    private boolean openSkyTest() {
        boolean bl = true;
        int n = (this.maxx + this.minx) / 2;
        int n2 = (this.maxz + this.minz) / 2;
        RenderObject[] renderObjectArray = this.mesh.getPolygons();
        for (int i = 0; i < renderObjectArray.length; ++i) {
            RenderObject renderObject;
            RenderObject renderObject2 = renderObjectArray[i];
            if (!Room.isPointOnPolygon(n, n2, renderObject2)) continue;
            if (renderObject2 instanceof Polygon3V) {
                renderObject = (Polygon3V)renderObject2;
                if (renderObject.ny > 2048) {
                    bl = false;
                }
            }
            if (!(renderObject2 instanceof Polygon4V)) continue;
            renderObject = (Polygon4V)renderObject2;
            if (((Polygon4V)renderObject).ny <= 2048) continue;
            bl = false;
        }
        return bl;
    }

    void addPortal(Portal portal) {
        if (this.portals == null) {
            this.portals = new Portal[0];
        }
        Portal[] portalArray = this.portals;
        this.portals = new Portal[portalArray.length + 1];
        System.arraycopy(portalArray, 0, this.portals, 0, portalArray.length);
        this.portals[this.portals.length - 1] = portal;
    }

    void setViewport(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
    }

    void render(Graphics3D graphics3D) {
        this.mesh.project(graphics3D, graphics3D.getInvCamera());
        graphics3D.addMesh(this.mesh, this.x1, this.y1, this.x2, this.y2);
        for (int i = 0; i < this.objects.size(); ++i) {
            RoomObject roomObject = (RoomObject)this.objects.elementAt(i);
            roomObject.render(graphics3D, this.x1, this.y1, this.x2, this.y2);
        }
    }

    boolean sphereCast(Vector3D vector3D, int n) {
        if (!SphereCast.isSphereAABBCollision((Vector3D)vector3D, (int)n, (int)this.minx, (int)this.maxx, (int)this.minz, (int)this.maxz)) {
            return false;
        }
        return SphereCast.sphereCast((Mesh)this.mesh, (Vector3D)vector3D, (int)n);
    }

    void rayCast(Ray ray) {
        if (!RayCast.isRayAABBCollision((Ray)ray, (int)this.minx, (int)this.maxx, (int)this.minz, (int)this.maxz)) {
            return;
        }
        RayCast.rayCast((Mesh)this.mesh, (Ray)ray);
    }

    int isPointOnMesh(int n, int n2) {
        if (n < this.minx || n2 < this.minz || n > this.maxx || n2 > this.maxz) {
            return -1;
        }
        RenderObject[] renderObjectArray = this.mesh.getPolygons();
        for (int i = 0; i < renderObjectArray.length; ++i) {
            if (!Room.isPointOnPolygon(n, n2, renderObjectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPointOnPolygon(int n, int n2, RenderObject renderObject) {
        if (renderObject instanceof Polygon3V) {
            Polygon3V polygon3V = (Polygon3V)renderObject;
            Vertex vertex = polygon3V.a;
            Vertex vertex2 = polygon3V.b;
            Vertex vertex3 = polygon3V.c;
            return MathUtils.isPointOnPolygon(n, n2, vertex.x, vertex.z, vertex2.x, vertex2.z, vertex3.x, vertex3.z, polygon3V.ny);
        }
        if (renderObject instanceof Polygon4V) {
            Polygon4V polygon4V = (Polygon4V)renderObject;
            Vertex vertex = polygon4V.a;
            Vertex vertex4 = polygon4V.b;
            Vertex vertex5 = polygon4V.c;
            Vertex vertex6 = polygon4V.d;
            return MathUtils.isPointOnPolygon(n, n2, vertex.x, vertex.z, vertex4.x, vertex4.z, vertex5.x, vertex5.z, vertex6.x, vertex6.z, polygon4V.ny);
        }
        return false;
    }

    public void addObject(RoomObject roomObject) {
        if (!this.objects.contains(roomObject)) {
            this.objects.addElement(roomObject);
        } else {
            System.out.println("Room: \u0421\u201a\u0420\u00b0\u0420\u0454\u0420\u0455\u0420\u2116 \u0420\u0455\u0420\u00b1\u0421\u0409\u0420\u00b5\u0420\u0454\u0421\u201a \u0421\u0453\u0420\u00b6\u0420\u00b5 \u0421\u0403\u0420\u0455\u0420\u0491\u0420\u00b5\u0421\u0402\u0420\u00b6\u0420\u0451\u0421\u201a\u0421\u0403\u0421\u040f");
        }
    }

    public void removeObject(RoomObject roomObject) {
        boolean bl = this.objects.removeElement(roomObject);
        if (!bl) {
            System.out.println("Room: \u0421\u201a\u0420\u00b0\u0420\u0454\u0420\u0455\u0420\u0456\u0420\u0455 \u0420\u0455\u0420\u00b1\u0421\u0409\u0420\u00b5\u0420\u0454\u0421\u201a\u0420\u00b0 \u0420\u0405\u0420\u00b5 \u0420\u00b1\u0421\u2039\u0420\u00bb\u0420\u0455");
        }
    }

    public void getObjects(Vector vector) {
        for (int i = 0; i < this.objects.size(); ++i) {
            vector.addElement(this.objects.elementAt(i));
        }
    }

    public Portal[] getPortals() {
        return this.portals;
    }

    public int getId() {
        return this.id;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public boolean isOpenSky() {
        return this.openSky;
    }
}

