/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.home;

import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Polygon3V;
import com.iceberg.graphics3d.Polygon4V;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.home.Home;
import com.iceberg.home.Portal;
import com.iceberg.home.Room;
import java.util.Vector;

public class HomeCreator {
    public static Home create(Mesh[] meshArray) {
        int n;
        Mesh mesh = meshArray[meshArray.length - 1];
        Portal[] portalArray = HomeCreator.createPortals(mesh.getPolygons());
        Room[] roomArray = new Room[meshArray.length - 1];
        for (n = 0; n < roomArray.length; ++n) {
            meshArray[n].optimize();
            roomArray[n] = new Room(meshArray[n], n);
        }
        for (n = 0; n < portalArray.length; ++n) {
            HomeCreator.findRooms(portalArray[n], roomArray);
        }
        Room[][] roomArray2 = HomeCreator.createNeighbours(roomArray);
        return new Home(roomArray, roomArray2);
    }

    private static Mesh searchMesh(Mesh[] meshArray, String string) {
        for (int i = 0; i < meshArray.length; ++i) {
            Mesh mesh = meshArray[i];
            String string2 = mesh.getName();
            if (string2 == null || !string2.toLowerCase().equals(string)) continue;
            return mesh;
        }
        return null;
    }

    private static Mesh[] removeMesh(Mesh[] meshArray, Mesh mesh) {
        Vector<Mesh> vector = new Vector<Mesh>();
        for (int i = 0; i < meshArray.length; ++i) {
            if (meshArray[i] == mesh) continue;
            vector.addElement(meshArray[i]);
        }
        Object[] objectArray = new Mesh[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static Portal[] createPortals(RenderObject[] renderObjectArray) {
        Portal[] portalArray = new Portal[renderObjectArray.length];
        for (int i = 0; i < renderObjectArray.length; ++i) {
            Vertex[] vertexArray = HomeCreator.getVertices(renderObjectArray[i]);
            portalArray[i] = new Portal(vertexArray);
        }
        return portalArray;
    }

    private static void findRooms(Portal portal, Room[] roomArray) {
        Room room = null;
        Room room2 = null;
        for (int i = 0; i < roomArray.length; ++i) {
            Room room3 = roomArray[i];
            if (!HomeCreator.isExistsCommonCoords(room3.getMesh(), portal.getVertices())) continue;
            if (room == null) {
                room = room3;
                continue;
            }
            room2 = room3;
            break;
        }
        if (room != null) {
            portal.setRoom1(room);
            room.addPortal(portal);
        }
        if (room2 != null) {
            portal.setRoom2(room2);
            room2.addPortal(portal);
        }
    }

    private static Room[][] createNeighbours(Room[] roomArray) {
        Room[][] roomArray2 = new Room[roomArray.length][];
        for (int i = 0; i < roomArray2.length; ++i) {
            roomArray2[i] = HomeCreator.getNearRooms(roomArray[i]);
        }
        return roomArray2;
    }

    private static Room[] getNearRooms(Room room) {
        Portal[] portalArray = room.getPortals();
        if (portalArray == null) {
            return new Room[0];
        }
        Room[] roomArray = new Room[portalArray.length];
        for (int i = 0; i < roomArray.length; ++i) {
            roomArray[i] = portalArray[i].getSecondRoom(room);
        }
        return roomArray;
    }

    private static Vertex[] getVertices(RenderObject renderObject) {
        if (renderObject instanceof Polygon3V) {
            Polygon3V polygon3V = (Polygon3V)renderObject;
            return new Vertex[]{polygon3V.a, polygon3V.b, polygon3V.c};
        }
        if (renderObject instanceof Polygon4V) {
            Polygon4V polygon4V = (Polygon4V)renderObject;
            return new Vertex[]{polygon4V.a, polygon4V.b, polygon4V.c, polygon4V.d};
        }
        return null;
    }

    private static boolean isExistsCommonCoords(Mesh mesh, Vertex[] vertexArray) {
        for (int i = 0; i < vertexArray.length; ++i) {
            if (!HomeCreator.contains(mesh, vertexArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Mesh mesh, Vertex vertex) {
        Vertex[] vertexArray = mesh.getVertices();
        for (int i = 0; i < vertexArray.length; ++i) {
            if (!HomeCreator.equals(vertexArray[i], vertex)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Vertex vertex, Vertex vertex2) {
        return vertex.x / 50 == vertex2.x / 50 && vertex.y / 50 == vertex2.y / 50 && vertex.z / 50 == vertex2.z / 50;
    }
}

