/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.RenderObject;
import com.iceberg.graphics3d.Texture;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;

public class MeshImage
extends RenderObject {
    private Matrix matrix = new Matrix();
    private Vertex centre;
    private int offsetSZ = 0;
    private Mesh mesh;
    private Morphing animation;
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public MeshImage(Mesh mesh, Morphing morphing) {
        this.mesh = mesh;
        this.animation = morphing;
        this.centre = MeshImage.computeCentre(mesh.getVertices());
    }

    public MeshImage(Mesh mesh) {
        this.mesh = mesh;
        this.centre = MeshImage.computeCentre(mesh.getVertices());
    }

    private static Vertex computeCentre(Vertex[] vertexArray) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < vertexArray.length; ++i) {
            Vertex vertex = vertexArray[i];
            l += (long)vertex.x;
            l2 += (long)vertex.y;
            l3 += (long)vertex.z;
        }
        return new Vertex((int)(l / (long)vertexArray.length), (int)(l2 / (long)vertexArray.length), (int)(l3 / (long)vertexArray.length));
    }

    public void setMatrix(Matrix matrix) {
        this.matrix.set(matrix);
        this.centre.transform(matrix);
        this.sz = this.centre.rz + this.offsetSZ;
    }

    public void setOffsetSZ(int n) {
        this.offsetSZ = n;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public Morphing getAnimation() {
        return this.animation;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        return true;
    }

    public void render(Graphics3D graphics3D, Texture texture) {
        if (this.animation != null) {
            this.mesh.animate(this.animation);
        }
        this.mesh.project(graphics3D, this.matrix);
        this.mesh.render(graphics3D, this.x1, this.y1, this.x2, this.y2);
    }

    public void render(Graphics3D graphics3D) {
        if (this.animation != null) {
            this.mesh.animate(this.animation);
        }
        this.mesh.project(graphics3D, this.matrix);
        this.mesh.render(graphics3D, this.x1, this.y1, this.x2, this.y2);
    }
}

