
#version 330

layout ( location = 0) in vec3 position;
layout ( location = 1) in vec2 uv;
layout ( location = 2) in vec3 normal;
layout ( location = 3) in vec3 tangent;
layout ( location = 4) in vec3 bitangent;


out vec2 TexCoords;
out vec3 FragPos;
out vec3 Normal;
out mat3 TBN;

uniform mat4 PV;
uniform mat4 M;


void main()
{
	 vec3 T = normalize(vec3(M * vec4(tangent,   0.0)));
	 vec3 B = normalize(vec3(M * vec4(bitangent, 0.0)));
	 vec3 N = normalize(vec3(M * vec4(normal,    0.0)));
	 TBN = mat3(T, B, N);

	FragPos = (M*vec4(position, 1.0)).xyz;
	TexCoords = vec2(uv.x, 1 - uv.y);
	Normal = normalize(mat3(M)*normal);
    gl_Position = PV*vec4(FragPos.xyz, 1);
}
