/*
 * Decompiled with CFR 0.152.
 */
package sound;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import sound.IOUtil;
import sound.OpenALInfo;

public class Sound {
    public int MINIGUN;
    public int CAN;
    public int HEARTBEAT;
    public int EATING;
    public int CASH;
    public int AK;
    public int PUNCH;
    public int CHAMBERING;
    public int POP;
    public int DEAGLE;
    private long device = ALC10.alcOpenDevice(null);
    private IntBuffer sources;
    private int nextSource = 0;

    public Sound(float volume) {
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open the default device.");
        }
        ALCCapabilities deviceCaps = ALC.createCapabilities((long)this.device);
        System.out.println("OpenALC10: " + deviceCaps.OpenALC10);
        System.out.println("OpenALC11: " + deviceCaps.OpenALC11);
        System.out.println("caps.ALC_EXT_EFX = " + deviceCaps.ALC_EXT_EFX);
        if (deviceCaps.OpenALC11) {
            List devices = ALUtil.getStringList((long)0L, (int)4115);
            if (devices == null) {
                OpenALInfo.checkALCError(0L);
            } else {
                int i = 0;
                while (i < devices.size()) {
                    System.out.println(String.valueOf(i) + ": " + (String)devices.get(i));
                    ++i;
                }
            }
        }
        String defaultDeviceSpecifier = ALC10.alcGetString((long)0L, (int)4100);
        System.out.println("Default device: " + defaultDeviceSpecifier);
        long context = ALC10.alcCreateContext((long)this.device, null);
        ALC10.alcMakeContextCurrent((long)context);
        AL.createCapabilities((ALCCapabilities)deviceCaps);
        System.out.println("ALC_FREQUENCY: " + ALC10.alcGetInteger((long)this.device, (int)4103) + "Hz");
        System.out.println("ALC_REFRESH: " + ALC10.alcGetInteger((long)this.device, (int)4104) + "Hz");
        System.out.println("ALC_SYNC: " + (ALC10.alcGetInteger((long)this.device, (int)4105) == 1));
        System.out.println("ALC_MONO_SOURCES: " + ALC10.alcGetInteger((long)this.device, (int)4112));
        System.out.println("ALC_STEREO_SOURCES: " + ALC10.alcGetInteger((long)this.device, (int)4113));
        AL10.alListenerf((int)4106, (float)volume);
        this.MINIGUN = Sound.load("sound/minigun.ogg");
        this.CAN = Sound.load("sound/can.ogg");
        this.HEARTBEAT = Sound.load("sound/heartbeat.ogg");
        this.EATING = Sound.load("sound/eating.ogg");
        this.CASH = Sound.load("sound/cash.ogg");
        this.AK = Sound.load("sound/ak.ogg");
        this.PUNCH = Sound.load("sound/punch.ogg");
        this.CHAMBERING = Sound.load("sound/chambering.ogg");
        this.POP = Sound.load("sound/pop.ogg");
        this.DEAGLE = Sound.load("sound/deagle.ogg");
        this.sources = BufferUtils.createIntBuffer((int)ALC10.alcGetInteger((long)this.device, (int)4112));
        AL10.alGenSources((IntBuffer)this.sources);
        OpenALInfo.checkALError();
    }

    public void play(int buffer) {
        this.play(buffer, 1.0f);
    }

    public void play(int buffer, float pitch) {
        AL10.alSourceStop((int)this.sources.get(this.nextSource));
        OpenALInfo.checkALError();
        AL10.alSourcei((int)this.sources.get(this.nextSource), (int)4105, (int)buffer);
        OpenALInfo.checkALError();
        AL10.alSourcef((int)this.sources.get(this.nextSource), (int)4099, (float)pitch);
        AL10.alSourcePlay((int)this.sources.get(this.nextSource));
        OpenALInfo.checkALError();
        ++this.nextSource;
        if (this.nextSource >= this.sources.capacity()) {
            this.nextSource = 0;
        }
    }

    public void free() {
        ALC10.alcCloseDevice((long)this.device);
    }

    private static int load(String oggPath) {
        int buffer = AL10.alGenBuffers();
        OpenALInfo.checkALError();
        Throwable throwable = null;
        Object var3_4 = null;
        try (STBVorbisInfo info = STBVorbisInfo.malloc();){
            ShortBuffer pcm = Sound.readVorbis(oggPath, 32768, info);
            AL10.alBufferData((int)buffer, (int)(info.channels() == 1 ? 4353 : 4355), (ShortBuffer)pcm, (int)info.sample_rate());
            OpenALInfo.checkALError();
            return buffer;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static ShortBuffer readVorbis(String resource, int bufferSize, STBVorbisInfo info) {
        ByteBuffer vorbis;
        try {
            vorbis = IOUtil.ioResourceToByteBuffer(resource, bufferSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IntBuffer error = BufferUtils.createIntBuffer((int)1);
        long decoder = STBVorbis.stb_vorbis_open_memory((ByteBuffer)vorbis, (IntBuffer)error, null);
        if (decoder == 0L) {
            throw new RuntimeException("Failed to open Ogg Vorbis file. Error: " + error.get(0));
        }
        STBVorbis.stb_vorbis_get_info((long)decoder, (STBVorbisInfo)info);
        int channels = info.channels();
        int lengthSamples = STBVorbis.stb_vorbis_stream_length_in_samples((long)decoder);
        ShortBuffer pcm = BufferUtils.createShortBuffer((int)lengthSamples);
        pcm.limit(STBVorbis.stb_vorbis_get_samples_short_interleaved((long)decoder, (int)channels, (ShortBuffer)pcm) * channels);
        STBVorbis.stb_vorbis_close((long)decoder);
        return pcm;
    }
}

