/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import game.Vec3;
import renderer.glengine.OBJLoader;
import renderer.glengine.Vector3f;

public class Mesh {
    public float[] vertices;
    public float[] textureCoords;
    public float[] normalCoords;
    public int[] indices;
    public Material material;
    public Vec3 min;
    public Vec3 max;

    public void setVertices(float[] vertices) {
        this.min = new Vec3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.max = new Vec3(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        this.vertices = vertices;
        int i = 0;
        while (i < vertices.length) {
            this.min.x = Math.min(this.min.x, (double)vertices[i + 0]);
            this.min.y = Math.min(this.min.y, (double)vertices[i + 1]);
            this.min.z = Math.min(this.min.z, (double)vertices[i + 2]);
            this.max.x = Math.max(this.max.x, (double)vertices[i + 0]);
            this.max.y = Math.max(this.max.y, (double)vertices[i + 1]);
            this.max.z = Math.max(this.max.z, (double)vertices[i + 2]);
            i += 3;
        }
    }

    public static Mesh getMesh(String path) {
        return Mesh.getMesh(path, 1.0f, true);
    }

    public static Mesh getMesh(String path, float scale) {
        return Mesh.getMesh(path, scale, true);
    }

    public static Mesh getMesh(String path, float scale, boolean forceFlatShading) {
        Mesh value = OBJLoader.LOADER.getIndexedMesh(path, scale, forceFlatShading);
        return value;
    }

    public static class Material {
        public Vector3f specular = Vector3f.POOL.next(0.0f, 0.0f, 0.0f);
    }
}

