/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIScene;
import org.lwjgl.assimp.Assimp;

public class AssimpLoader {
    public static AIMesh load(String path) {
        if (!path.endsWith(".obj")) {
            throw new RuntimeException("Only obj supported");
        }
        InputStream in = AssimpLoader.class.getResourceAsStream(path);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byteArray = buffer.toByteArray();
        ByteBuffer b = BufferUtils.createByteBuffer((int)(byteArray.length + 1));
        b.put(byteArray).put((byte)10).rewind();
        AIScene as = Assimp.aiImportFileFromMemory((ByteBuffer)b, (int)294987, (CharSequence)"obj");
        PointerBuffer meshesBuffer = as.mMeshes();
        int meshCount = as.mNumMeshes();
        if (meshCount != 1) {
            throw new RuntimeException("Meshcount: " + meshCount);
        }
        return AIMesh.create((long)meshesBuffer.get(0));
    }
}

