/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import renderer.glengine.Texture;

public class TextureFont {
    private Texture[] CHARS;
    private int fontSize;

    public TextureFont(String path, int fontSize) {
        this.fontSize = fontSize;
        char num = '\u0100';
        this.CHARS = new Texture[num];
        Font font = this.loadFont(path, fontSize);
        FontMetrics metrics = new BufferedImage(30, 30, 2).getGraphics().getFontMetrics(font);
        char c = '\u0000';
        while (c < num) {
            if (!Character.isISOControl(c)) {
                int hgt = metrics.getHeight();
                int adv = metrics.stringWidth("" + c);
                Dimension size = new Dimension(adv + 1, hgt + 8);
                BufferedImage charImg = new BufferedImage(size.width, size.height, 2);
                Graphics go = charImg.getGraphics();
                Graphics2D g = (Graphics2D)go;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setFont(font);
                g.setColor(Color.WHITE);
                g.drawString("" + c, 0, size.height - 4);
                this.CHARS[c] = new Texture(charImg);
            }
            c = (char)(c + '\u0001');
        }
    }

    private Font loadFont(String path, float size) {
        InputStream is = Texture.class.getResourceAsStream(path);
        Font font = null;
        try {
            font = Font.createFont(0, is);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        return font.deriveFont(size);
    }

    public void free() {
    }

    public Texture getCharTexture(int c) {
        return this.CHARS[c];
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public float getStringWidth(String text) {
        int width = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n') {
                throw new RuntimeException("Does not support multiline strings");
            }
            width += this.getCharTexture((int)text.charAt((int)i)).width;
            ++i;
        }
        return width;
    }
}

