/*
 * Decompiled with CFR 0.152.
 */
package physics;

import com.bulletphysics.collision.shapes.VertexData;
import javax.vecmath.Tuple3f;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIVector3D;

public class TriangleVertexData
extends VertexData {
    private AIMesh mesh;
    private float scale;

    public TriangleVertexData(AIMesh mesh, float scale) {
        this.mesh = mesh;
        this.scale = scale;
    }

    public int getIndex(int i) {
        return ((AIFace)this.mesh.mFaces().get(i / 3)).mIndices().get(i % 3);
    }

    public int getIndexCount() {
        return this.mesh.mNumFaces() * 3;
    }

    public <T extends Tuple3f> T getVertex(int v, T tuple) {
        tuple.x = ((AIVector3D)this.mesh.mVertices().get(v)).x() * this.scale;
        tuple.y = ((AIVector3D)this.mesh.mVertices().get(v)).y() * this.scale;
        tuple.z = ((AIVector3D)this.mesh.mVertices().get(v)).z() * this.scale;
        return tuple;
    }

    public int getVertexCount() {
        return this.mesh.mNumVertices();
    }

    public void setVertex(int i, float x, float y, float z) {
        ((AIVector3D)this.mesh.mVertices().get(i)).x(x);
        ((AIVector3D)this.mesh.mVertices().get(i)).y(y);
        ((AIVector3D)this.mesh.mVertices().get(i)).z(z);
    }
}

