/*
 * Decompiled with CFR 0.152.
 */
package noise;

import game.MathUtils;
import game.Vec2;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JFrame;

public class Perlin {
    private Vec2[][] gradient;
    public double[][] noise;
    double max = 0.0;

    public Perlin(int width, int height, int seed) {
        int y;
        Random r = new Random(seed);
        this.gradient = new Vec2[width + 1][height + 1];
        int x = 0;
        while (x < this.gradient.length) {
            y = 0;
            while (y < this.gradient[x].length) {
                double a = r.nextDouble() * Math.PI * 2.0;
                this.gradient[x][y] = new Vec2(Math.cos(a), Math.sin(a));
                ++y;
            }
            ++x;
        }
        this.noise = new double[width][height];
        x = 1;
        while (x < this.noise.length) {
            y = 1;
            while (y < this.noise[x].length) {
                this.noise[x][y] = this.perlin((double)x * 0.03 + 0.5, (double)y * 0.03 + 0.5);
                ++y;
            }
            ++x;
        }
    }

    double dotGridGradient(int ix, int iy, double x, double y) {
        double dx = x - (double)ix;
        double dy = y - (double)iy;
        return dx * this.gradient[ix][iy].x + dy * this.gradient[ix][iy].y;
    }

    public double perlin(double x, double y) {
        int x0 = x > 0.0 ? (int)x : (int)x - 1;
        int x1 = x0 + 1;
        int y0 = y > 0.0 ? (int)y : (int)y - 1;
        int y1 = y0 + 1;
        double sx = x - (double)x0;
        double sy = y - (double)y0;
        double n0 = this.dotGridGradient(x0, y0, x, y);
        double n1 = this.dotGridGradient(x1, y0, x, y);
        double ix0 = MathUtils.lerp(n0, n1, sx);
        n0 = this.dotGridGradient(x0, y1, x, y);
        n1 = this.dotGridGradient(x1, y1, x, y);
        double ix1 = MathUtils.lerp(n0, n1, sx);
        double value = MathUtils.lerp(ix0, ix1, sy);
        this.max = Math.max(this.max, value);
        return value;
    }

    public static void main(String[] args) {
        int width = 800;
        int height = 800;
        final BufferedImage img = new BufferedImage(width, height, 2);
        JFrame frame = new JFrame(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.drawImage(img, 0, 0, null);
            }
        };
        frame.setSize(width, height);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        Perlin p = new Perlin(width, height, 1234);
        double[][] noise = p.noise;
        System.out.println(p.max);
        Graphics g = img.getGraphics();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                double n = noise[x][y];
                n /= p.max;
                n += 1.0;
                g.setColor(new Color((int)(255.0 * (n *= 0.5)), (int)(255.0 * n), (int)(255.0 * n)));
                g.drawRect(x, y, 1, 1);
                ++y;
            }
            ++x;
        }
        g.dispose();
        frame.setVisible(true);
    }
}

