/*
 * Decompiled with CFR 0.152.
 */
package lights;

import game.Game;
import game.Vec3;
import lights.Light;

public class DecayingLight
extends Light {
    private Vec3 color;
    private float strength;
    private Vec3 pos;
    private long start;
    private int millis;

    public DecayingLight(Vec3 pos, Vec3 color, float strength, int millis) {
        this.color = color;
        this.strength = strength;
        this.pos = pos;
        this.millis = millis;
        this.start = System.currentTimeMillis();
    }

    @Override
    public Vec3 getColor() {
        return this.color;
    }

    @Override
    public Vec3 getPosition() {
        return this.pos;
    }

    @Override
    public float getStrength() {
        float t = (float)(System.currentTimeMillis() - this.start) / (float)this.millis;
        return this.strength * (1.0f - t);
    }

    @Override
    public boolean shallBeRemoved(Game game) {
        return System.currentTimeMillis() - this.start > (long)this.millis;
    }
}

