/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Enemy;
import game.Vec3;
import java.util.Stack;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;

public class Model {
    protected float bodyTopWidth = 1.0f;
    protected float bodyBotWidth = 0.5f;
    protected float bodyHeight = 1.0f;
    protected float armUpperLength = 1.0f;
    protected float armLowerLength = 1.0f;
    protected float handLength = 1.0f;
    protected float headLength = 1.0f;
    protected float legUpperLength = 1.0f;
    protected float legLowerLength = 1.0f;
    protected float feetLength = 1.0f;
    protected Vec3 headRot = new Vec3();
    protected Vec3 legLeftUpperRot = new Vec3();
    protected Vec3 legLeftLowerRot = new Vec3();
    protected Vec3 footLeftRot = new Vec3();
    protected Vec3 legRightUpperRot = new Vec3();
    protected Vec3 legRightLowerRot = new Vec3();
    protected Vec3 footRightRot = new Vec3();
    protected Vec3 armLeftUpperRot = new Vec3();
    protected Vec3 armLeftLowerRot = new Vec3();
    protected Vec3 handLeftRot = new Vec3();
    protected Vec3 armRightUpperRot = new Vec3();
    protected Vec3 armRightLowerRot = new Vec3();
    protected Vec3 handRightRot = new Vec3();
    protected int animationStartTick = 0;
    Enemy enemy;
    int i = 0;
    public State state = State.WALKING;

    public Model(Enemy e) {
        this.enemy = e;
    }

    public void update() {
        Vec3 headRotOld = this.headRot.clone();
        Vec3 legLeftUpperRotOld = this.legLeftUpperRot.clone();
        Vec3 legLeftLowerRotOld = this.legLeftLowerRot.clone();
        Vec3 footLeftRotOld = this.footLeftRot.clone();
        Vec3 legRightUpperRotOld = this.legRightUpperRot.clone();
        Vec3 legRightLowerRotOld = this.legRightLowerRot.clone();
        Vec3 footRightRotOld = this.footRightRot.clone();
        Vec3 armLeftUpperRotOld = this.armLeftUpperRot.clone();
        Vec3 armLeftLowerRotOld = this.armLeftLowerRot.clone();
        Vec3 handLeftRotOld = this.handLeftRot.clone();
        Vec3 armRightUpperRotOld = this.armRightUpperRot.clone();
        Vec3 armRightLowerRotOld = this.armRightLowerRot.clone();
        Vec3 handRightRotOld = this.handRightRot.clone();
        if (this.state == State.WALKING) {
            this.walkAnimation(this.i);
        } else if (this.state == State.PUNCHING) {
            this.punchAnimation(this.i);
        } else {
            this.deadAnimation(this.i);
        }
        float k = 0.05f;
        this.headRot = Vec3.interpolateTowards(headRotOld, this.headRot, k);
        this.legLeftUpperRot = Vec3.interpolateTowards(legLeftUpperRotOld, this.legLeftUpperRot, k);
        this.legLeftLowerRot = Vec3.interpolateTowards(legLeftLowerRotOld, this.legLeftLowerRot, k);
        this.footLeftRot = Vec3.interpolateTowards(footLeftRotOld, this.footLeftRot, k);
        this.legRightUpperRot = Vec3.interpolateTowards(legRightUpperRotOld, this.legRightUpperRot, k);
        this.legRightLowerRot = Vec3.interpolateTowards(legRightLowerRotOld, this.legRightLowerRot, k);
        this.footRightRot = Vec3.interpolateTowards(footRightRotOld, this.footRightRot, k);
        this.armLeftUpperRot = Vec3.interpolateTowards(armLeftUpperRotOld, this.armLeftUpperRot, k);
        this.armLeftLowerRot = Vec3.interpolateTowards(armLeftLowerRotOld, this.armLeftLowerRot, k);
        this.handLeftRot = Vec3.interpolateTowards(handLeftRotOld, this.handLeftRot, k);
        this.armRightUpperRot = Vec3.interpolateTowards(armRightUpperRotOld, this.armRightUpperRot, k);
        this.armRightLowerRot = Vec3.interpolateTowards(armRightLowerRotOld, this.armRightLowerRot, k);
        this.handRightRot = Vec3.interpolateTowards(handRightRotOld, this.handRightRot, k);
        ++this.i;
    }

    private void deadAnimation(int i2) {
        this.legLeftUpperRot = new Vec3();
        this.legLeftLowerRot = new Vec3();
        this.footLeftRot = new Vec3();
        this.legRightUpperRot = new Vec3();
        this.legRightLowerRot = new Vec3();
        this.footRightRot = new Vec3();
        this.armLeftUpperRot = new Vec3();
        this.armLeftLowerRot = new Vec3();
        this.handLeftRot = new Vec3();
        this.armRightUpperRot = new Vec3();
        this.armRightLowerRot = new Vec3();
        this.handRightRot = new Vec3();
    }

    public void setAnimationStartTick(int i) {
        this.animationStartTick = i;
    }

    public void walkAnimation(int ij) {
        float k = this.enemy.isHeadShotted ? 10.0f : 20.0f;
        float i = (float)ij * 0.5f + (float)(this.enemy.randomNumber * 1000.0);
        float sc = this.enemy.isHeadShotted ? 3.0f : 2.5f;
        this.armRightUpperRot = new Vec3();
        this.armRightUpperRot.x = (float)((double)(sc * 35.0f) * Math.sin(Math.PI / (double)k * (double)i));
        this.armRightUpperRot.z = -10.0;
        this.legRightUpperRot.x = -((float)((double)(sc * 35.0f) * Math.sin(Math.PI / (double)k * (double)i)));
        this.legRightLowerRot.x = (float)((double)(sc * 30.0f) * Math.sin(Math.PI / (double)k * (double)i)) * (float)(i % 40.0f <= 20.0f ? 1 : 0);
        this.armRightLowerRot.x = -40.0;
        this.armLeftLowerRot.x = -40.0;
        this.armLeftUpperRot = new Vec3();
        this.armLeftUpperRot.x = -((float)((double)(sc * 35.0f) * Math.sin(Math.PI / (double)k * (double)i)));
        this.armLeftUpperRot.z = 10.0;
        this.legLeftUpperRot.x = (float)((double)(sc * 35.0f) * Math.sin(Math.PI / (double)k * (double)i));
        this.legLeftLowerRot.x = -((float)((double)(sc * 30.0f) * Math.sin(Math.PI / (double)k * (double)i))) * (float)(i % 40.0f >= 20.0f ? 1 : 0);
    }

    public void punchAnimation(int ij) {
        float sc = 2.5f;
        float i = (float)ij + (float)(this.enemy.randomNumber * 1000.0);
        this.armRightUpperRot = new Vec3();
        this.armRightUpperRot.z = -70.0;
        this.armRightUpperRot.y = (float)((double)(sc * 80.0f) * Math.sin(0.15707963267948966 * (double)i) * (double)(i % 40.0f <= 20.0f ? 1 : 0));
        this.armRightLowerRot.x = -((float)(90.0 - (double)(sc * 50.0f) * Math.sin(0.15707963267948966 * (double)i) * (double)(i % 40.0f <= 20.0f ? 1 : 0)));
        this.armLeftUpperRot = new Vec3();
        this.armLeftUpperRot.z = 70.0;
        this.armLeftUpperRot.y = -((float)((double)(sc * 80.0f) * Math.sin(0.15707963267948966 * (double)(i % 20.0f)) * (double)(i % 40.0f >= 20.0f ? 1 : 0)));
        this.armLeftUpperRot.x = -((float)((double)sc * Math.sin(0.15707963267948966 * (double)(i % 20.0f))));
        this.armLeftLowerRot.x = -((float)(90.0 - (double)(sc * 50.0f) * Math.sin(0.15707963267948966 * (double)(i % 20.0f)) * (double)(i % 40.0f >= 20.0f ? 1 : 0)));
    }

    public void jumpAnimation(int i) {
        i = this.animationStartTick - i;
        this.armRightUpperRot.z = (float)(-50.0 - 15.0 * Math.sin(0.07853981633974483 * (double)i) * (double)(i % 160 <= 80 ? true : true));
        this.armRightLowerRot.x = -60.0;
        this.armLeftUpperRot.z = (float)(50.0 + 15.0 * Math.sin(0.07853981633974483 * (double)i) * (double)(i % 160 <= 80 ? true : true));
        this.armLeftLowerRot.x = -60.0;
        this.legLeftUpperRot.x = (float)(-15.0 * Math.sin(0.07853981633974483 * (double)i));
        this.legLeftLowerRot.x = 20.0;
        this.legRightUpperRot.x = (float)(15.0 * Math.sin(0.07853981633974483 * (double)i));
        this.legRightLowerRot.x = 20.0;
    }

    private void renderBox(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        Matrix4f mc = Matrix4f.scale(1.0f, 1.0f, 1.0f);
        mc.set(m);
        Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z).multiply(Matrix4f.scale((float)dim.x, (float)dim.y, (float)dim.z)));
        mb.add(ResourceHandler.cylinder, ResourceHandler.metal, f);
    }

    public void render(MeshBatch mb, Matrix4f.Pipeline p) {
        Stack<Matrix4f.Pipeline> stack = new Stack<Matrix4f.Pipeline>();
        stack.add(p);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(0.0f, 0.1f, 0.0f);
        float w = 0.2f;
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight(90.0f, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(0.0f, this.bodyHeight + this.legLowerLength + this.legUpperLength, 0.0f);
        this.renderBody(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix());
        stack.add(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.headRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.headRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.headRot.z, 0.0f, 0.0f, 1.0f);
        this.renderHead(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(0.0, this.headLength / 2.0f, 0.0), new Vec3(w, this.headLength, w));
        stack.pop();
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        this.renderArm(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0), new Vec3(w, this.armUpperLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        this.renderArm(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0), new Vec3(w, this.armLowerLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handLeftRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handLeftRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handLeftRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        this.renderHand(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0), new Vec3(w, this.handLength, w), true);
        stack.pop();
        stack.pop();
        stack.pop();
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, 0.0f, 0.0f);
        this.renderArm(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength / 2.0f, 0.0), new Vec3(w, this.armUpperLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, -this.armUpperLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.armRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, this.armUpperLength, 0.0f);
        this.renderArm(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength / 2.0f, 0.0), new Vec3(w, this.armLowerLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handRightRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handRightRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.handRightRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, this.armUpperLength + this.armLowerLength, 0.0f);
        this.renderHand(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyTopWidth / 2.0f, -this.armUpperLength - this.armLowerLength - this.handLength / 2.0f, 0.0), new Vec3(w, this.handLength, w), false);
        stack.pop();
        stack.pop();
        stack.pop();
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, -this.bodyHeight, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftUpperRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftUpperRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftUpperRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, this.bodyHeight, 0.0f);
        this.renderLeg(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0), new Vec3(w, this.legUpperLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftLowerRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftLowerRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legLeftLowerRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        this.renderLeg(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0), new Vec3(w, this.legLowerLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyTopWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footLeftRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footLeftRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footLeftRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyTopWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        this.renderFoot(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), false);
        stack.pop();
        stack.pop();
        stack.pop();
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyBotWidth / 2.0f, -this.bodyHeight, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightUpperRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightUpperRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightUpperRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyBotWidth / 2.0f, this.bodyHeight, 0.0f);
        this.renderLeg(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength / 2.0f, 0.0), new Vec3(w, this.legUpperLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightLowerRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightLowerRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.legRightLowerRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength, 0.0f);
        this.renderLeg(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength / 2.0f, 0.0), new Vec3(w, this.legLowerLength, w));
        stack.push(((Matrix4f.Pipeline)stack.peek()).copy());
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footRightRot.x, 1.0f, 0.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footRightRot.y, 0.0f, 1.0f, 0.0f);
        ((Matrix4f.Pipeline)stack.peek()).addRotateRight((float)this.footRightRot.z, 0.0f, 0.0f, 1.0f);
        ((Matrix4f.Pipeline)stack.peek()).addTranslateRight(this.bodyBotWidth / 2.0f, this.bodyHeight + this.legUpperLength + this.legLowerLength, 0.0f);
        this.renderFoot(mb, ((Matrix4f.Pipeline)stack.peek()).getMatrix(), new Vec3(-this.bodyBotWidth / 2.0f, -this.bodyHeight - this.legUpperLength - this.legLowerLength, this.feetLength / 2.0f), new Vec3(w, w, this.feetLength), true);
    }

    public void renderBody(MeshBatch mb, Matrix4f m) {
        float w = 0.2f;
        this.renderBox(mb, m, new Vec3(0.0, -this.bodyHeight / 2.0f, 0.0), new Vec3(w, this.bodyHeight, w));
        this.renderBox(mb, m, new Vec3(0.0, 0.0, 0.0), new Vec3(this.bodyTopWidth, w, w));
        this.renderBox(mb, m, new Vec3(0.0, -this.bodyHeight, 0.0), new Vec3(this.bodyBotWidth, w, w));
    }

    public void renderArm(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        this.renderBox(mb, m, pos, dim);
    }

    public void renderLeg(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        this.renderBox(mb, m, pos, dim);
    }

    public void renderHead(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        this.renderBox(mb, m, pos, dim);
    }

    public void renderHand(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim, boolean left) {
        this.renderBox(mb, m, pos, dim);
    }

    public void renderFoot(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim, boolean left) {
        this.renderBox(mb, m, pos, dim);
    }

    public float getWidth() {
        return Math.max(this.bodyTopWidth, this.bodyBotWidth);
    }

    public float getHeight() {
        return this.headLength + this.bodyHeight + this.legUpperLength + this.legLowerLength;
    }

    public float getTopHalfHeigth() {
        return this.headLength;
    }

    public void reset() {
        this.headRot = new Vec3();
        this.legLeftUpperRot = new Vec3();
        this.legLeftLowerRot = new Vec3();
        this.footLeftRot = new Vec3();
        this.legRightUpperRot = new Vec3();
        this.legRightLowerRot = new Vec3();
        this.footRightRot = new Vec3();
        this.armLeftUpperRot = new Vec3();
        this.armLeftLowerRot = new Vec3();
        this.handLeftRot = new Vec3();
        this.armRightUpperRot = new Vec3();
        this.armRightLowerRot = new Vec3();
        this.handRightRot = new Vec3();
    }

    public static enum Limb {
        HAND_RIGHT,
        HEAD;

    }

    public static enum State {
        WALKING,
        PUNCHING,
        DEAD;

    }
}

