/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.util.Random;

public class MathUtils {
    public static final Random random = new Random(1234L);

    public static double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static double random() {
        return random.nextDouble();
    }

    public static double smoothstep(double x, double edge0, double edge1) {
        double t = MathUtils.clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    public static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double lerp(double a, double b, double w) {
        return (1.0 - w) * a + w * b;
    }
}

