/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MathUtils;
import game.Vec2i;
import game.Vec3;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import noise.OpenSimplexNoise;
import renderer.glengine.Mesh;
import renderer.glengine.MeshBatch;

public class Map {
    public final double tileSize = 1.0;
    public Vec2i mapSize;
    public double[][] heightMap;
    public static final double WATER_LEVEL = -0.5;
    public static final double LAND_LEVEL = 0.7;
    public static final double WATER_METAL_DEPTH = -5.0;
    Mesh mesh = new Mesh();

    public static void main(String[] args) {
        Map m = new Map(false);
        try {
            m.writeOBJ();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeOBJ() throws FileNotFoundException {
        File file = new File("src/obj/map.obj");
        PrintWriter out = new PrintWriter(file.getAbsolutePath());
        out.println();
        int i = 0;
        while (i < this.mesh.vertices.length) {
            out.println("v " + this.mesh.vertices[i] + " " + this.mesh.vertices[i + 1] + " " + this.mesh.vertices[i + 2]);
            i += 3;
        }
        out.println();
        i = 0;
        while (i < this.mesh.textureCoords.length) {
            out.println("vt " + this.mesh.textureCoords[i] + " " + this.mesh.textureCoords[i + 1]);
            i += 2;
        }
        out.println();
        i = 0;
        while (i < this.mesh.normalCoords.length) {
            out.println("vn " + this.mesh.normalCoords[i] + " " + this.mesh.normalCoords[i + 1] + " " + this.mesh.normalCoords[i + 2]);
            i += 3;
        }
        out.println();
        out.println("s 1");
        i = 0;
        while (i < this.mesh.indices.length) {
            int a = this.mesh.indices[i] + 1;
            int b = this.mesh.indices[i + 1] + 1;
            int c = this.mesh.indices[i + 2] + 1;
            out.println("f " + a + "/" + a + "/" + a + " " + b + "/" + b + "/" + b + " " + c + "/" + c + "/" + c);
            i += 3;
        }
        out.close();
    }

    public Map() {
        this(true);
    }

    public Map(boolean onlyHeightMap) {
        int i;
        int y;
        long seed = 54263L;
        System.out.println("Seed: " + seed);
        Random r = new Random(seed);
        int minSize = 150;
        int variation = 150;
        this.mapSize = new Vec2i(500, 500);
        this.heightMap = new double[this.mapSize.x][this.mapSize.y];
        this.generateHeightMap(seed, r);
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> normals = new ArrayList<Float>();
        ArrayList<Float> uvs = new ArrayList<Float>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        double[][] hmMesh = (double[][])this.heightMap.clone();
        int x = 0;
        while (x < hmMesh.length) {
            y = 0;
            while (y < hmMesh[x].length) {
                if (hmMesh[x][y] == 0.7) {
                    hmMesh[x][y] = 0.7 + MathUtils.random() * 0.1;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < hmMesh.length) {
            y = 0;
            while (y < hmMesh[x].length) {
                Vec3 a = new Vec3((double)x * 1.0, hmMesh[x][y], (double)y * 1.0);
                vertices.add(Float.valueOf((float)a.x));
                vertices.add(Float.valueOf((float)a.y));
                vertices.add(Float.valueOf((float)a.z));
                Vec3 avgn = this.averageNormal(x, y, hmMesh);
                normals.add(Float.valueOf((float)avgn.x));
                normals.add(Float.valueOf((float)avgn.y));
                normals.add(Float.valueOf((float)avgn.z));
                i = 0;
                while (i < 3) {
                    ++i;
                }
                i = 0;
                while (i < 3) {
                    ++i;
                }
                uvs.add(Float.valueOf((float)x * 0.25f));
                uvs.add(Float.valueOf((float)y * 0.25f));
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.heightMap.length - 1) {
            y = 0;
            while (y < this.heightMap[x].length - 1) {
                indices.add(y + x * this.heightMap[x].length);
                indices.add(y + 1 + x * this.heightMap[x].length);
                indices.add(y + (x + 1) * this.heightMap[x].length);
                indices.add(y + 1 + x * this.heightMap[x].length);
                indices.add(y + (x + 1) * this.heightMap[x].length);
                indices.add(y + 1 + (x + 1) * this.heightMap[x].length);
                ++y;
            }
            ++x;
        }
        float[] vs = new float[vertices.size()];
        float[] ns = new float[normals.size()];
        int[] is = new int[indices.size()];
        float[] ts = new float[indices.size()];
        i = 0;
        for (Float f : vertices) {
            float f2 = vs[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        i = 0;
        for (Float f : normals) {
            float f3 = ns[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        i = 0;
        for (Float f : uvs) {
            float f4 = ts[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        i = 0;
        for (Integer n : indices) {
            int n2 = is[i++] = n != null ? n : Integer.MAX_VALUE;
        }
        this.mesh.vertices = vs;
        this.mesh.indices = is;
        this.mesh.normalCoords = ns;
        this.mesh.textureCoords = ts;
    }

    private double noiseOctave(OpenSimplexNoise p1, double x, double y, int octaves, double persistence, double freqFactor) {
        double n = 0.0;
        double amplitude = 1.0;
        double frequency = 1.0;
        double maxValue = 0.0;
        int i = 0;
        while (i < octaves) {
            n += 0.5 * (1.0 + p1.eval((x + (double)i) * frequency, (y + (double)i) * frequency)) * amplitude;
            maxValue += amplitude;
            amplitude *= persistence;
            frequency *= freqFactor;
            ++i;
        }
        return n / maxValue;
    }

    private void generateHeightMap(long seed, Random r) {
        OpenSimplexNoise p1 = new OpenSimplexNoise(seed);
        double[][] noise = new double[this.mapSize.x][this.mapSize.y];
        double f1 = 1.0E-4 + r.nextDouble() * 0.02;
        double f2 = 0.005 + r.nextDouble() * 0.01;
        f1 = 0.01;
        f2 = 0.1;
        double fm = 0.005;
        double rf = 0.05;
        double f3 = 0.025;
        double s1 = 1.0;
        double s2 = 0.8;
        double s3 = 0.6;
        double s4 = 0.02;
        double s5 = 0.015;
        int x = 0;
        while (x < this.mapSize.x) {
            int y = 0;
            while (y < this.mapSize.y) {
                double n = this.noiseOctave(p1, f1 * (double)x, f1 * (double)y, 8, 0.6f, 2.0);
                double river = this.noiseOctave(p1, rf * (double)x, rf * (double)y, 1, 0.6f, 2.0);
                double mountain = this.noiseOctave(p1, fm * (double)x, fm * (double)y, 8, 0.6f, 2.0);
                noise[x][y] = n;
                ++y;
            }
            ++x;
        }
        double mountain = 5.0;
        int x2 = 0;
        while (x2 < this.heightMap.length) {
            int y = 0;
            while (y < this.heightMap[x2].length) {
                this.heightMap[x2][y] = (noise[x2][y] - 0.5) * 50.0;
                if (this.heightMap[x2][y] > 0.7) {
                    if (this.heightMap[x2][y] > 0.7 + mountain) {
                        double[] dArray = this.heightMap[x2];
                        int n = y;
                        dArray[n] = dArray[n] - mountain;
                        double[] dArray2 = this.heightMap[x2];
                        int n2 = y;
                        dArray2[n2] = dArray2[n2] * 1.1;
                    } else {
                        this.heightMap[x2][y] = 0.7;
                    }
                }
                ++y;
            }
            ++x2;
        }
    }

    public Vec3 averageNormal(int x, int y, double[][] totalHeightMap) {
        if (x < 1 || y < 1 || x >= totalHeightMap.length - 1 || y >= totalHeightMap[0].length - 1) {
            return new Vec3(0.0, 0.0, 1.0);
        }
        Vec3 avg = new Vec3();
        Vec3 p1 = new Vec3((double)(x - 1) * 1.0, (double)(y - 1) * 1.0, totalHeightMap[x - 1][y - 1]);
        Vec3 p2 = new Vec3((double)x * 1.0, (double)(y - 1) * 1.0, totalHeightMap[x][y - 1]);
        Vec3 p3 = new Vec3((double)(x + 1) * 1.0, (double)(y - 1) * 1.0, totalHeightMap[x + 1][y - 1]);
        Vec3 p4 = new Vec3((double)(x - 1) * 1.0, (double)y * 1.0, totalHeightMap[x - 1][y]);
        Vec3 p5 = new Vec3((double)x * 1.0, (double)y * 1.0, totalHeightMap[x][y]);
        Vec3 p6 = new Vec3((double)(x + 1) * 1.0, (double)y * 1.0, totalHeightMap[x + 1][y]);
        Vec3 p7 = new Vec3((double)(x - 1) * 1.0, (double)(y + 1) * 1.0, totalHeightMap[x - 1][y + 1]);
        Vec3 p8 = new Vec3((double)x * 1.0, (double)(y + 1) * 1.0, totalHeightMap[x][y + 1]);
        Vec3 p9 = new Vec3((double)(x + 1) * 1.0, (double)(y + 1) * 1.0, totalHeightMap[x + 1][y + 1]);
        Vec3 n1 = p5.subtract(p4).cross(p5.subtract(p2));
        Vec3 n2 = p2.subtract(p3).cross(p2.subtract(p5));
        Vec3 n3 = p6.subtract(p5).cross(p6.subtract(p3));
        Vec3 n4 = p5.subtract(p5).cross(p5.subtract(p8));
        Vec3 n5 = p8.subtract(p7).cross(p8.subtract(p5));
        Vec3 n6 = p4.subtract(p5).cross(p4.subtract(p7));
        avg.x = (n1.x + n2.x + n3.x + n4.x + n5.x + n6.x) / 6.0;
        avg.z = (n1.y + n2.y + n3.y + n4.y + n5.y + n6.y) / 6.0;
        avg.y = (n1.z + n2.z + n3.z + n4.z + n5.z + n6.z) / 6.0;
        return avg;
    }

    public void render(MeshBatch mb) {
    }

    public Vec2i posToTile(double x, double y) {
        return new Vec2i((int)(x / 1.0), (int)(y / 1.0));
    }

    public double getHeight(double x, double y) {
        return this.getHeight(x, y, this.heightMap);
    }

    public double getHeight(double x, double y, double[][] hMap) {
        double x1 = MathUtils.clamp((int)(x / 1.0), 0.0, hMap.length - 2);
        double y1 = MathUtils.clamp((int)(y / 1.0), 0.0, hMap[(int)x1].length - 2);
        double x2 = MathUtils.clamp(x1 + 1.0, 1.0, hMap.length - 1);
        double y2 = MathUtils.clamp(y1 + 1.0, 1.0, hMap[(int)x2].length - 1);
        double fQ11 = hMap[(int)x1][(int)y1];
        double fQ21 = hMap[(int)x2][(int)y1];
        double fQ12 = hMap[(int)x1][(int)y2];
        double fQ22 = hMap[(int)x2][(int)y2];
        double numerator = fQ11 * (x2 - (x /= 1.0)) * (y2 - (y /= 1.0)) + fQ21 * (x - x1) * (y2 - y) + fQ12 * (x2 - x) * (y - y1) + fQ22 * (x - x1) * (y - y1);
        double denominator = (x2 - x1) * (y2 - y1);
        return numerator / denominator;
    }

    public boolean isOnMap(double x, double y) {
        return x >= 0.0 && y >= 0.0 && x < (double)this.mapSize.x * 1.0 && y < (double)this.mapSize.y * 1.0;
    }
}

