/*
 * Decompiled with CFR 0.152.
 */
package game;

import effects.Explosion;
import effects.ParticleEffect;
import entities.AK47;
import entities.Allianshallen;
import entities.Billys;
import entities.Deagle;
import entities.Entity;
import entities.Jolt;
import entities.Minigun;
import game.Droid;
import game.Enemy;
import game.Player;
import game.Vec3;
import input.KeyHandler;
import java.util.ArrayList;
import javax.vecmath.Vector3f;
import lights.Light;
import lights.PlayerLight;
import lights.PositionLight;
import physics.Physics;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;
import renderer.glengine.Window;
import sound.Sound;

public class Game {
    public static boolean DEBUG = false;
    public ArrayList<Entity> entities = new ArrayList();
    public Physics physics = new Physics();
    public Player player;
    ArrayList<Enemy> enemies = new ArrayList();
    ArrayList<ParticleEffect> effects = new ArrayList();
    public ArrayList<Light> lights = new ArrayList();
    public long tick = 0L;
    public Sound sound = new Sound(1.0f);
    ArrayList<Vec3> enemySpawns = new ArrayList();
    int spawnTimer;
    ArrayList<Vec3> itemSpawns = new ArrayList();
    public boolean[] itemSpawnFree;
    int itemSpawnTimer;
    boolean inShoppingRange = false;
    String[] items = new String[]{"Billys", "Jolt", "AK47", "Minigun", "Jolt Flak", "Deagle"};
    int joltCost = 30;
    int jf = (int)((double)(this.joltCost * 24) * 0.5);
    int[] costs = new int[]{50, this.joltCost, 1000, 8000, this.jf, 200};

    public Game() {
        this.enemySpawns.add(new Vec3(22.707618713378906, 1.788710355758667, 51.870296478271484));
        this.enemySpawns.add(new Vec3(87.2356185913086, 1.7913761734962463, 51.4073600769043));
        this.enemySpawns.add(new Vec3(87.49610900878906, 3.3677563667297363, 88.15940856933594));
        this.enemySpawns.add(new Vec3(25.1227f, 1.869406282901764, 87.54680633544922));
        this.enemySpawns.add(new Vec3(84.81023406982422, 1.5651722848415375, 47.13401794433594));
        this.enemySpawns.add(new Vec3(93.30526733398438, 1.7995925545692444, 85.13371276855469));
        this.enemySpawns.add(new Vec3(116.47016143798828, 1.799332082271576, 86.0467758178711));
        this.enemySpawns.add(new Vec3(118.43907165527344, 1.7983134388923645, 53.115386962890625));
        this.enemySpawns.add(new Vec3(66.00215911865234, 1.7991079688072205, 55.31606674194336));
        this.itemSpawns.add(new Vec3(66.18382263183594, 2.899927020072937, 86.86774444580078));
        this.itemSpawns.add(new Vec3(88.35794830322266, 1.7993640303611755, 89.24517059326172));
        this.itemSpawns.add(new Vec3(22.09994125366211, 1.8366442918777466, 52.98893356323242));
        this.itemSpawns.add(new Vec3(48.177974700927734, 1.7997243404388428, 54.783626556396484));
        this.itemSpawns.add(new Vec3(61.216896057128906, 1.7996698021888733, 55.30625534057617));
        this.itemSpawns.add(new Vec3(89.48588562011719, 1.7992668151855469, 51.01345f));
        this.itemSpawns.add(new Vec3(84.71141815185547, 1.574108213186264, 47.151092529296875));
        this.itemSpawns.add(new Vec3(73.8968505859375, 1.574373f, 43.57560729980469));
        this.itemSpawns.add(new Vec3(104.0968017578125, 1.7997235655784607, 62.04008102416992));
        this.itemSpawns.add(new Vec3(118.43977355957031, 1.8867841958999634, 52.0581f));
        this.itemSpawns.add(new Vec3(116.31443786621094, 1.7991126775741577, 86.39224243164062));
        this.itemSpawns.add(new Vec3(92.58111572265625, 1.794365f, 74.39443969726562));
        int i = 0;
        while (i < 10) {
            ++i;
        }
        this.lights.add(new PositionLight(new Vec3(66.0, 5.5, 83.0), new Vec3(1.0, 0.0, 0.0), 1.0f){

            @Override
            public Vec3 getDir() {
                double r = (double)System.currentTimeMillis() * 0.001;
                return new Vec3(Math.sin(r), Math.abs(Math.cos(r)), 0.0);
            }
        });
        this.reloadEntities();
        this.player = new Player(this);
        this.lights.add(new PlayerLight(new Vec3(0.8, 0.7, 0.5), 0.4f, this.player));
        int groundSize = 10;
        int worldSize = 300;
        int x = -worldSize / 2;
        while (x <= worldSize / 2) {
            int z = -worldSize / 2;
            while (z <= worldSize / 2) {
                this.physics.createStaticBox(new Vector3f((float)groundSize, (float)groundSize, (float)groundSize), new Vector3f((float)x, (float)(-groundSize), (float)z));
                z += groundSize;
            }
            x += groundSize;
        }
    }

    public void reloadEntities() {
        this.itemSpawnFree = new boolean[this.itemSpawns.size()];
        int i = 0;
        while (i < this.itemSpawnFree.length) {
            this.itemSpawnFree[i] = true;
            ++i;
        }
        i = 0;
        while (i < this.entities.size()) {
            this.physics.remove(this.entities.get(i).getBody());
            ++i;
        }
        this.entities.clear();
        if (this.player != null) {
            this.entities.add(this.player.entity);
            this.physics.add(this.player.entity.getBody());
        }
        i = 0;
        while (i < this.enemies.size()) {
            Enemy e = this.enemies.get(i);
            this.physics.remove(e.getBody());
            ++i;
        }
        this.enemies.clear();
        int x = 0;
        while (x < 21) {
            int y = 0;
            while (y < 21) {
                if (x == 0 || y == 0 || x != 20) {
                    // empty if block
                }
                ++y;
            }
            ++x;
        }
        this.entities.add(new Allianshallen(this.physics, new Vector3f(70.0f, 0.0f, 70.0f), new Vector3f(0.0f, 0.0f, 0.0f), this));
        this.entities.add(new Entity(this.physics, new Vector3f(55.0f, 1.0f, 91.3f), new Vector3f(0.0f, 0.0f, 0.0f), ResourceHandler.cube, null, true, ResourceHandler.doorTexture, 0.0, 2.5f));
        x = 0;
        while (x < 20) {
            int y = 0;
            while (y < 20) {
                ++y;
            }
            ++x;
        }
    }

    public double toRealAngle(double angle) {
        while (true) {
            if (angle > Math.toRadians(360.0)) {
                angle -= Math.PI * 2;
                continue;
            }
            if (!(angle < 0.0)) break;
            angle += Math.PI * 2;
        }
        return angle;
    }

    public void tick() {
        Vec3 shopPos;
        if (!this.player.alive) {
            if (KeyHandler.pressed(82)) {
                this.restart();
            }
            return;
        }
        if (KeyHandler.pressed(292)) {
            DEBUG = !DEBUG;
        }
        Vec3 screenPos = new Vec3(66.0, 0.0, 88.0);
        Vec3 pPos = new Vec3(this.player.pos.x, 0.0, this.player.pos.z);
        double headingRad = this.toRealAngle(this.player.headingRad);
        double headingUpDownRad = this.toRealAngle(this.player.headingUpDownRad);
        if (pPos.lengthDifference(screenPos) < 4.5 && headingRad > 2.5 && headingRad < 3.7 && headingUpDownRad > 0.25 && headingUpDownRad < 0.8 && this.tick % 20L == 0L) {
            this.player.addScore(1);
        }
        if (this.player.pos.lengthDifference(shopPos = new Vec3(77.0, 0.0, 44.0)) < 6.0) {
            this.inShoppingRange = true;
            Vec3 l = new Vec3(0.0, 0.0, 0.0);
            l.x = Math.cos(-this.player.headingUpDownRad) * Math.sin(this.player.headingRad);
            l.y = Math.sin(-this.player.headingUpDownRad);
            l.z = Math.cos(-this.player.headingUpDownRad) * Math.cos(this.player.headingRad);
            l.normalize();
            float r = 1.5f;
            Vector3f spawnPos = new Vector3f((float)(this.player.pos.x - (double)r * l.x), (float)(this.player.pos.y - (double)r * l.y), (float)(this.player.pos.z - (double)r * l.z));
            if (KeyHandler.pressed(49) && this.player.kr >= this.costs[0]) {
                this.player.kr -= this.costs[0];
                this.entities.add(new Billys(this.physics, spawnPos, new Vector3f(0.0f, 0.0f, 0.0f)));
                this.sound.play(this.sound.CASH);
            }
            if (KeyHandler.pressed(50) && this.player.kr >= this.costs[1]) {
                this.player.kr -= this.costs[1];
                this.entities.add(new Jolt(this.physics, spawnPos, new Vector3f(0.0f, 0.0f, 0.0f)));
                this.sound.play(this.sound.CASH);
            }
            if (KeyHandler.pressed(51) && this.player.kr >= this.costs[2]) {
                this.player.kr -= this.costs[2];
                this.entities.add(new AK47(this.physics, spawnPos, new Vector3f(0.0f, 0.0f, 0.0f), this));
                this.sound.play(this.sound.CASH);
            }
            if (KeyHandler.pressed(52) && this.player.kr >= this.costs[3]) {
                this.player.kr -= this.costs[3];
                this.entities.add(new Minigun(this.physics, spawnPos, new Vector3f(0.0f, 0.0f, 0.0f), this));
                this.sound.play(this.sound.CASH);
            }
            if (KeyHandler.pressed(53) && this.player.kr >= this.costs[4]) {
                this.player.kr -= this.costs[4];
                float d = 0.15f;
                int x = 0;
                while (x < 4) {
                    int y = 0;
                    while (y < 6) {
                        this.entities.add(new Jolt(this.physics, new Vector3f(spawnPos.x + (float)x * d, 0.5f, spawnPos.z + (float)y * d), new Vector3f(0.0f, 0.0f, 0.0f)));
                        ++y;
                    }
                    ++x;
                }
                this.sound.play(this.sound.CASH);
            }
            if (KeyHandler.pressed(54) && this.player.kr >= this.costs[5]) {
                this.player.kr -= this.costs[5];
                this.entities.add(new Deagle(this.physics, spawnPos, new Vector3f(0.0f, 0.0f, 0.0f), this));
                this.sound.play(this.sound.CASH);
            }
        } else {
            this.inShoppingRange = false;
        }
        this.physics.update();
        for (Entity e : this.entities) {
            e.update();
        }
        this.player.tick(this, this.physics);
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).tick(this);
            ++i;
        }
        i = 0;
        while (i < this.effects.size()) {
            if (this.effects.get(i).tick(this)) {
                this.effects.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.lights.size()) {
            if (this.lights.get(i).shallBeRemoved(this)) {
                this.lights.remove(i);
                --i;
            }
            ++i;
        }
        if (this.spawnTimer == 0) {
            int k = Game.getPoisson(10.0);
            this.spawnTimer = k = (int)((double)(k * 60) * (0.8 + 0.2 * Math.random()));
            int num = 1;
            Vec3 spawn = this.enemySpawns.get((int)(Math.random() * (double)this.enemySpawns.size()));
            int alive = 0;
            int i2 = 0;
            while (i2 < this.enemies.size()) {
                if (this.enemies.get((int)i2).alive) {
                    ++alive;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < num) {
                if (alive < 3) {
                    this.enemies.add(new Droid(this, spawn.x, spawn.y, spawn.z));
                }
                ++i2;
            }
        }
        if (this.itemSpawnTimer <= 0) {
            this.spawnItem();
        }
        --this.itemSpawnTimer;
        --this.spawnTimer;
        ++this.tick;
    }

    private void restart() {
        this.player.kr = 200;
        this.player.resetScore();
        this.player.moveToSpawn();
        this.player.alive = true;
        this.player.resetHP();
        this.reloadEntities();
    }

    public static int getPoisson(double lambda) {
        double L = Math.exp(-lambda);
        double p = 1.0;
        int k = 0;
        do {
            ++k;
        } while ((p *= Math.random()) > L);
        return k - 1;
    }

    public void render(MeshBatch mb) {
        for (Entity e : this.entities) {
            e.render(mb);
        }
        int i = 0;
        while (i < this.enemies.size()) {
            this.enemies.get(i).render(mb);
            ++i;
        }
        this.player.render(mb, this);
        if (this.inShoppingRange) {
            Matrix4f.Pipeline ps = new Matrix4f.Pipeline();
            ps.addScale(100.0f);
            ps.addTranslate(20.0f, 120.0f, 0.0f);
            mb.addSprite(ResourceHandler.shop, ps.getMatrix());
            int i2 = 0;
            while (i2 < this.costs.length) {
                mb.addString(i2 + 1 + ". " + this.items[i2] + "  " + this.costs[i2] + "kr", mb.nextVector3f(20.0f, 230 + 25 * i2, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
                ++i2;
            }
        }
        double b = (float)this.player.lastScoreTick / 30.0f;
        b = Math.min(b, 1.0);
        mb.addString("Score: " + this.player.getScore(), mb.nextVector3f(Window.width / 2 - 100, 20.0f, 0.0f), mb.nextVector3f(1.0f, 1.0f, (float)b), ResourceHandler.score);
        mb.addString("KR: " + this.player.kr, mb.nextVector3f(20.0f, 70.0f, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
        if (!this.player.alive) {
            mb.addString("DEAD! ", mb.nextVector3f(Window.width / 2 - 120, Window.height / 2 - 200, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.countdown);
            mb.addString("Press R to restart ", mb.nextVector3f(Window.width / 2 - 500, Window.height / 2 - 50, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.countdown);
        }
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        int i3 = 0;
        while (i3 < this.effects.size()) {
            this.effects.get(i3).render(mb, this.player);
            ++i3;
        }
        p = new Matrix4f.Pipeline();
        p.add(Matrix4f.scale(2000.0f, 2000.0f, 2000.0f));
        mb.add(ResourceHandler.cube, ResourceHandler.scratch, p.getMatrix());
    }

    public Vec3 getCamera() {
        return this.player.pos;
    }

    public boolean hitScan(Enemy enemy) {
        Vec3 c = enemy.getCenterVec3();
        Vec3 o = this.player.pos;
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-this.player.headingUpDownRad) * Math.sin(this.player.headingRad);
        l.y = Math.sin(-this.player.headingUpDownRad);
        l.z = Math.cos(-this.player.headingUpDownRad) * Math.cos(this.player.headingRad);
        l.normalize();
        double r = 1.0;
        Vec3 s = o.subtract(c);
        double dot = l.dot(s);
        double len = s.length();
        return dot * dot - len * len + r * r >= 0.0;
    }

    public void kill(int index) {
        Vec3 pos = this.enemies.get(index).getCenterVec3();
        this.effects.add(new Explosion(pos.x, pos.y, pos.z, this, -1));
        this.enemies.remove(index);
    }

    public void spawnItem() {
        int i = (int)(Math.random() * (double)this.itemSpawns.size());
        int j = 0;
        while (j < this.itemSpawns.size()) {
            int index = (i + j) % this.itemSpawnFree.length;
            if (this.itemSpawnFree[index]) {
                double r = Math.random();
                Vec3 p = this.itemSpawns.get(index);
                this.itemSpawnFree[index] = false;
                if (r > 0.9) {
                    this.entities.add(new Deagle(this.physics, p.toVector3f(), new Vector3f(0.0f, 0.0f, 0.0f), this, index));
                } else if (r > 0.85) {
                    this.entities.add(new AK47(this.physics, p.toVector3f(), new Vector3f(0.0f, 0.0f, 0.0f), this, index));
                } else if (r > 0.8) {
                    this.entities.add(new Minigun(this.physics, p.toVector3f(), new Vector3f(0.0f, 0.0f, 0.0f), this, index));
                } else if (r > 0.4) {
                    this.entities.add(new Jolt(this.physics, p.toVector3f(), new Vector3f(0.0f, 0.0f, 0.0f), index));
                } else {
                    this.entities.add(new Billys(this.physics, p.toVector3f(), new Vector3f(0.0f, 0.0f, 0.0f), index));
                }
            }
            ++j;
        }
        this.itemSpawnTimer = 600;
    }
}

