/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.Transform;
import entities.ZombieHead;
import game.Enemy;
import game.Game;
import game.Player;
import game.Vec3;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.assimp.AIVector3D;
import physics.Physics;
import renderer.DiffuseNormalSpecularTexture;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;

public class Entity {
    protected RigidBody body;
    protected Physics physics;
    public AIMesh mesh;
    public DiffuseNormalSpecularTexture dnsTexture;
    protected float scale;
    private boolean boxCollision;
    public AIMesh collisionMesh;
    public double throwDamage = 0.0;
    public int spawnIndex = -1;
    public boolean isHeadShotted = false;
    public double randomNumber = 0.0;
    protected Vector3f boxTranslation = new Vector3f();

    public Entity(Physics physics, Vector3f pos, Vector3f rot, AIMesh mesh, AIMesh collisionMesh, boolean boxCollision, DiffuseNormalSpecularTexture dnsTexture, double weight) {
        this(physics, pos, rot, mesh, collisionMesh, boxCollision, dnsTexture, weight, 1.0f);
    }

    public Entity(Physics physics, Vector3f pos, Vector3f rot, AIMesh mesh, AIMesh collisionMesh, boolean boxCollision, DiffuseNormalSpecularTexture dnsTexture, double weight, float scale) {
        this(physics, pos, rot, mesh, collisionMesh, boxCollision, dnsTexture, weight, scale, 1.0f);
    }

    public Entity(Physics physics, Vector3f pos, Vector3f rot, AIMesh mesh, AIMesh collisionMesh, boolean boxCollision, DiffuseNormalSpecularTexture dnsTexture, double weight, float scale, float debugYScale) {
        this.physics = physics;
        this.mesh = mesh;
        this.scale = scale;
        this.boxCollision = boxCollision;
        this.collisionMesh = collisionMesh;
        if (boxCollision) {
            Vector3f size = new Vector3f();
            Vector3f center = new Vector3f();
            this.getBounds(mesh, size, center);
            pos.x += center.x;
            pos.y += center.y;
            pos.z += center.z;
            this.boxTranslation = center;
            size.x *= 0.5f * scale;
            size.y *= 0.5f * scale * debugYScale;
            size.z *= 0.5f * scale;
            this.body = physics.createBox(size, pos, (float)weight, rot);
        } else {
            this.body = physics.createBodyFromMesh(collisionMesh, pos, (float)weight, rot, scale);
        }
        this.dnsTexture = dnsTexture;
        this.setBodyUserPointer();
        this.randomNumber = Math.random();
    }

    private void getBounds(AIMesh mesh, Vector3f size, Vector3f center) {
        float xmax = -999999.0f;
        float ymax = -999999.0f;
        float zmax = -999999.0f;
        float xmin = 999999.0f;
        float ymin = 999999.0f;
        float zmin = 999999.0f;
        int i = 0;
        while (i < mesh.mNumVertices()) {
            xmax = Math.max(xmax, ((AIVector3D)mesh.mVertices().get(i)).x());
            ymax = Math.max(ymax, ((AIVector3D)mesh.mVertices().get(i)).y());
            zmax = Math.max(zmax, ((AIVector3D)mesh.mVertices().get(i)).z());
            xmin = Math.min(xmin, ((AIVector3D)mesh.mVertices().get(i)).x());
            ymin = Math.min(ymin, ((AIVector3D)mesh.mVertices().get(i)).y());
            zmin = Math.min(zmin, ((AIVector3D)mesh.mVertices().get(i)).z());
            ++i;
        }
        size.x = xmax - xmin;
        size.y = ymax - ymin;
        size.z = zmax - zmin;
        center.x = (xmax + xmin) * 0.5f;
        center.y = (ymax + ymin) * 0.5f;
        center.z = (zmax + zmin) * 0.5f;
    }

    public void render(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix4f real = new Matrix4f();
        real.m00 = mat.m00;
        real.m01 = mat.m01;
        real.m02 = mat.m02;
        real.m03 = mat.m03;
        real.m10 = mat.m10;
        real.m11 = mat.m11;
        real.m12 = mat.m12;
        real.m13 = mat.m13;
        real.m20 = mat.m20;
        real.m21 = mat.m21;
        real.m22 = mat.m22;
        real.m23 = mat.m23;
        real.m30 = mat.m30;
        real.m31 = mat.m31;
        real.m32 = mat.m32;
        real.m33 = mat.m33;
        real = real.multiply(Matrix4f.scale(this.scale, this.scale, this.scale));
        Matrix4f fix = Matrix4f.translate(-this.boxTranslation.x, -this.boxTranslation.y, -this.boxTranslation.z);
        real = real.multiply(fix);
        meshBatch.add(this.mesh, this.dnsTexture, real);
    }

    protected void setBodyUserPointer() {
        this.body.setUserPointer((Object)this);
    }

    public void update() {
    }

    public Vector3f getCenter() {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        return trans.origin;
    }

    public RigidBody getBody() {
        return this.body;
    }

    public void collidedWith(Entity entity) {
    }

    public boolean isStatic() {
        return this.body.getInvMass() == 0.0f;
    }

    public void cleanUp() {
    }

    public boolean canBePickedUp() {
        return false;
    }

    public boolean use(Game game, Physics.CustomClosestRayResultCallback c) {
        return false;
    }

    public void throwItem(Player player) {
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-player.headingUpDownRad) * Math.sin(player.headingRad);
        l.y = Math.sin(-player.headingUpDownRad);
        l.z = Math.cos(-player.headingUpDownRad) * Math.cos(player.headingRad);
        l.normalize();
        float str = 24.0f;
        this.physics.add(this.body);
        this.body.applyCentralImpulse(new Vector3f((float)(-l.x * (double)str), (float)(-l.y * (double)str), (float)(-l.z * (double)str)));
        this.body.activate();
    }

    public boolean isPlayer() {
        return false;
    }

    public void renderInHand(MeshBatch mb, boolean leftHand) {
    }

    public void moveToHand(Player player, float angle) {
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-player.headingUpDownRad / 2.0 + (double)0.4f) * Math.sin(player.headingRad + (double)angle);
        l.y = Math.sin(-player.headingUpDownRad / 2.0 + (double)0.4f);
        l.z = Math.cos(-player.headingUpDownRad / 2.0 + (double)0.4f) * Math.cos(player.headingRad + (double)angle);
        l.normalize();
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        float r = 1.0f;
        mat.setTranslation(new Vector3f((float)(player.pos.x - (double)r * l.x), (float)(player.pos.y - (double)r * l.y), (float)(player.pos.z - (double)r * l.z)));
        float k = angle < 0.0f ? 1 : -1;
        mat.setRotation(new AxisAngle4f(new Vector3f(0.0f, 1.0f, 0.0f), (float)player.headingRad + 90.0f + k * angle));
        trans.set(mat);
        this.body.setWorldTransform(trans);
        this.body.activate();
    }

    public void pickUp(Game game) {
        this.physics.remove(this.body);
        if (this.spawnIndex != -1) {
            game.itemSpawnFree[this.spawnIndex] = true;
            this.spawnIndex = -1;
        }
    }

    public void onHit(Game game) {
        float rly;
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-game.player.headingUpDownRad) * Math.sin(game.player.headingRad);
        l.y = Math.sin(-game.player.headingUpDownRad);
        l.z = Math.cos(-game.player.headingUpDownRad) * Math.cos(game.player.headingRad);
        l.normalize();
        float near = 0.0f;
        Vector3f from = new Vector3f((float)(game.player.pos.x - (double)near * l.x), (float)(game.player.pos.y - (double)near * l.y), (float)(game.player.pos.z - (double)near * l.z));
        float far = 150.0f;
        Vector3f towards = new Vector3f((float)(game.player.pos.x - (double)far * l.x), (float)(game.player.pos.y - (double)far * l.y), (float)(game.player.pos.z - (double)far * l.z));
        Physics.CustomClosestRayResultCallback c = game.physics.rayTest(from, towards);
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix3f mm = new Matrix3f();
        mat.getRotationScale(mm);
        float s = 1000.0f;
        Vector3f f = new Vector3f((float)(-l.x * (double)s), (float)(-l.y * (double)s), (float)(-l.z * (double)s));
        Vector3f cen = c.e.getCenter();
        Vector3f rel = new Vector3f((float)(game.player.pos.x - (double)cen.x), (float)(game.player.pos.y - (double)cen.y), (float)(game.player.pos.z - (double)cen.z));
        if ((double)mm.m11 > 0.9 && this instanceof Enemy && (double)(rly = c.pos.y - cen.y) > 0.53 && (double)rly < 0.94 && !this.isHeadShotted) {
            this.isHeadShotted = true;
            ZombieHead head = new ZombieHead(this.physics, new Vector3f(cen.x, cen.y + 0.8f, cen.z), new Vector3f(0.0f, 0.0f, 0.0f));
            game.entities.add(head);
            float s2 = 0.5f;
            Vector3f f2 = new Vector3f(s2 * f.x, s2 * f.y, s2 * f.z);
            head.body.applyCentralForce(f2);
            game.player.addScore(50);
            game.sound.play(game.sound.POP);
        }
        c.e.getBody().applyForce(f, rel);
        c.e.getBody().activate();
    }

    public void useDown(Game game, Physics.CustomClosestRayResultCallback c) {
    }
}

