#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform float drum;
uniform float incDrum;
//////////////////////////////////////////////////////
vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float length8( vec2 p )
{
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float sdCylinder( vec3 p, float r )
{
  return length(p.xz)-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

mat3 rot(float x, float y, float z)
{
	float cx = cos(x);
	float sx = sin(x);
	float cy = cos(y);
	float sy = sin(y);
	float cz = cos(z);
	float sz = sin(z);
	mat3 xm = mat3(1, 0, 0,
					0, cx, -sx,
					0, sx, cx);
	mat3 ym = mat3(cy, 0, sy,
			  		0, 1, 0,
			  		-sy, 0, cy);
	mat3 zm = mat3(cz, -sz, 0,
					sz, cz, 0,
					0, 0, 1);
	return xm * ym * zm;
}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

vec4 laserLight(vec3 pos) {
	float d = 9.0;
	vec3 part = floor(pos / d);
	part.z += 21;
	float t = part.z * 0.1;
	float td = 2.5;
	pos -= vec3(sin(t) * td, cos(t) * td, 0);
	pos.z = mod(pos.z, d) - d * 0.5;
	pos *= rot(0 , 0, part.z * 2.2);

	vec3 lightCol = vec3(0.5 + 0.5 * sin(part.z), 0.5 + 0.5 * sin(part.z * 2), 0.5 + 0.5 * sin(part.z * 3));
	lightCol = normalize(lightCol);
	float distanceToL = max(0.0001, sdCylinder(pos, 0.001));
	vec3 point = lightCol * 5.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}

vec4 morphLight(vec3 pos) {
	float d = 30.0;
	vec3 part = floor(pos / d);
//	pos -= vec3(0, -1, 0);
	pos -= vec3(0.5, 0.5, 0);
//	pos -= vec3(0, sin(part.z)*1.5, 0);
	pos.z = mod(pos.z, d) - d * 0.5;

	vec3 lightCol = vec3(0.5 + 0.5 * cos(part.z), 0.5 + 0.5 * cos(part.z * 2), 0.5 + 0.5 * cos(part.z * 3));
	lightCol = normalize(lightCol);

	pos *= rot(sin(iGlobalTime), sin(iGlobalTime * 2), sin(iGlobalTime * 3));
	float a = sdTorus88(pos, vec2(1.0, 0.1));
	float b = sdTorus(pos, vec2(1.0, 0.1));
	float c = udRoundBox(pos, vec3(0.3), 0.2);
	float mt = 2.0;
	float t = mod(iGlobalTime + 2.0, mt * 3.0);
	float t1 = smoothstep(mt*0.0, mt*1.0, t);
	float t2 = smoothstep(mt*1.0, mt*2.0, t);
	float t3 = smoothstep(mt*2.0, mt*3.0, t);
	float mdis = a*(1.0-t1) + b*t1*(1.0-t2)+ c*t2*(1.0-t3) + t3*a;


	float distanceToL = max(0.0001, mdis);
	vec3 point = lightCol * 10.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}

vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 l = laserLight(pos);
	vec4 l2 = laserLight(pos + vec3(0, 0, 160));
//	vec4 m = morphLight(pos);
	dis = l.w;
	dis = min(l.w, l2.w);
//	return l.xyz + m.xyz;
	return l.xyz + l2.xyz;
}

void addLightning(inout vec3 color, vec3 normal, vec3 eye, vec3 pos) {

//	vec3 lpos = LPOS;//vec3(1, 1, -2);
	vec3 lpos = vec3(0);

	float dis = length(lpos - pos);
	vec3 invLight = normalize(lpos - pos);
	float diffuse = max(0.0, dot(invLight, normal));
	float spec = specular(normal, -invLight, normalize(eye - pos), 220.0);

	float str = 1.0/(0.5 + 0.01*dis + 0.1*dis*dis);
	float tmp = 0;
	str = 1;
	color =  color * (0.0 + 0.8*diffuse*evaluateLight(pos, tmp).xyz) + spec*str;
//	color = clamp(color, vec3(0), vec3(1));
	//color *= str;
}

float smin( float a, float b)
{
	float k = 0.5;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}
vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);

	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}


#define TEX 0.2
#define SIZE 8.0
#define PI 3.1415

#define MAT_WALL 1.0





vec2 wall(vec3 pos, vec3 rd) {
	vec3 d = vec3(1.0);
	vec3 q = mod(pos, d) - 0.5 * d;

	vec3 s = (d * 0.5 -  sign(rd)* q) / abs(rd);
	vec3 part = floor(pos / d);
//	pos = mod(pos, d) - d * 0.5;

	float dis = 0;
//	float partDis = -sdHexPrism(part, vec2(3,99999));
//	float r = floor(1 + mod(part.z * 0.25, 1) * 3);
//	float partDis = -udBox(part,vec3(r, r, 999999));
	float partDis = -sdHexPrism(part, vec2(5,99999));
	if (partDis < 0) {
		dis = udRoundBox(q, vec3(0.25 * d.x), 0.3 * d.x);
	} else {
		float b = min(s.x, min(s.y, s.z));
		dis = max(0.01 , b);
	}
//		dis = udRoundBox(q, vec3(0.4), 0.1);
//	dis = -sdHexPrism(pos, vec2(8,99999));
//	dis = -sdCylinder(pos.xzy, 10);
	return vec2(dis, MAT_WALL);

}
vec2 map(vec3 p, vec3 rd) {
	vec2 res = wall(p, rd);
	return res;
}



vec3 getNormal(vec3 p, vec3 rd)
{
	vec3 normal;
    vec3 ep = vec3(0.005, 0, 0);
    normal.x = map(p + ep.xyz, rd).x - map(p - ep.xyz, rd).x;
    normal.y = map(p + ep.yxz, rd).x - map(p - ep.yxz, rd).x;
    normal.z = map(p + ep.yzx, rd).x - map(p - ep.yzx, rd).x;
    return normalize(normal);

}

float occlusion(vec3 p, vec3 normal, vec3 rd)
{
	float o = clamp(2*map(p + normal * 0.5, rd).x, 0, 1);
	return 0.2 + 0.8*o;
}



vec3 raymarch(vec3 ro, vec3 rd, vec3 eye) {
	float t = 0.0;
	const int maxIter = 2000;
	const float maxDis = 3000.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 col = vec3(0);
	const int jumps = 100;
	float ref = 1.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
	for (int j = 0; j < jumps; j++) {
		for (int i = 0; i < maxIter; i++) {
			p = ro + rd * t;

			vec2 res = map(p, rd);
			d = res.x;
//			d = min(d, 0.2);
			float fogAmount = 0.03;
			float lightDis = -1.0;
			vec3 light = evaluateLight(p, lightDis);
			d = min(min(d, 1), max(lightDis, 0.001));
			vec3 lightIntegrated = light - light * exp(-fogAmount * d);
			scatteredLight += transmittance * lightIntegrated;
			transmittance *= exp(-fogAmount * d);

			t += d;
			float m = res.y;
			bool end = i == maxIter - 1 ||t > maxDis;
			if (d < 0.001 || end) {
				vec3 c = vec3(1);
				vec3 normal = getNormal(p, rd);
				if (m == MAT_WALL) {
					c = vec3(0);
				}
//				c *= occlusion(p, normal, rd);
				addLightning(c, normal, eye, p);
				if (end) {
					transmittance = 0;
				}
				col = mix(col, transmittance * c + scatteredLight, ref);
//				col = mix(col, vec3(0.7), clamp(t * 0.01, 0, 1));
				if (m == MAT_WALL) {
					vec3 d = vec3(1.0);
					vec3 q = mod(p, d) - 0.5 * d;
					float s = 0.45;
					float x = abs(q.x) < s ? 1 : 0;
					float y = abs(q.y) < s ? 1 : 0;
					float z = abs(q.z) < s ? 1 : 0;
//					if ( x + y + z >= 2.0 ) {
//						ref *= 0.8;
//					} else {
//						ref = 0.0;
//					}
					ref *= 0.9;
				} else {
					ref = 0.0;
				}
				rd = reflect(rd, getNormal(p, rd));
				ro = p + rd*0.05;
				t = 0;
				break;
			}
			if (t > maxDis) {
				break;
			}
		}

		if (ref < 0.1) {
			break;
		}
	}
	return col;
}





void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (9.0/ 16.0);//* (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(0.5, 0.5 , max(0.0, iGlobalTime-5) * 16.2 + 103);
	vec3 tar = eye + vec3(0.0, 0.0, 1.0);
	float rot = max(0.0, iGlobalTime-5) * 0.5;
	vec3 lol = vec3(cos(rot), sin(rot), 0);
	if (iGlobalTime < 10) {
//		eye = vec3(0.5,2.5 - smoothstep(0, 5, iGlobalTime)*2.5 , max(0.0, iGlobalTime-10) * 15 + 103);
		float t = (1-smoothstep(0, 5, iGlobalTime)) * 3.1415 * 0.5;
		tar = eye + vec3(0.0, sin(t), cos(t));
	}
	vec3 dir = normalize(tar - eye);

	vec3 right = normalize(cross(lol, dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 0.0, 26.0 );

	float material = -1.0;
	vec3 color = raymarch(ro, rd, eye);

    fragColor = vec4(color, 1.0);
    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));
    fragColor.rgb = mix(fragColor.rgb, vec3(1),  smoothstep(19.5,20.0, iGlobalTime));
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
