#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
/////////////////////////////////////////////////////

float sea_octave(vec2 uv, float choppy) {
    uv += texture2D(iChannel0, uv);       
    vec2 wv = 1.0-abs(sin(uv));
    vec2 swv = abs(cos(uv));    
    wv = mix(wv,swv,wv);
    return pow(1.0-pow(wv.x * wv.y,0.65),choppy);
}

float hash( in vec2 p ) {
	float h = dot(p,vec2(127.1,311.7));	
    return fract(sin(h)*43758.5453123);
}

float noise( in vec2 p ) {
    vec2 i = floor( p );
    vec2 f = fract( p );	
	vec2 u = f*f*(3.0-2.0*f);
    return mix( mix( hash( i + vec2(0.0,0.0) ), 
                     hash( i + vec2(1.0,0.0) ), u.x),
                mix( hash( i + vec2(0.0,1.0) ), 
                     hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

float noiseOctave(in vec2 p, int octaves, float persistence)
{
	float n = 0;
	float amplitude = 1;
	float frequency = 1;
	float maxValue = 0;

	for(int i = 0; i < octaves; i++)
	{
		n += noise((p) * frequency) * amplitude;
		maxValue += amplitude;
		amplitude *= persistence;
		frequency *= 2.0;
	}
	return n / maxValue; 
}

float map(vec3 p)
{   

	float t = iGlobalTime * 0.015;

	const float ps = 0.065;
	p.x *= ps * 0.2;
	p.z *= ps;
	

	float h =  
				texture2D(iChannel0, 1.1 * p.xz  + 0.0* vec2(t * 0.1, t)).x + 
			   texture2D(iChannel0, 1.2 * p.xz  + 3.5* vec2(t * 0.1, t)).x;
	//float h = noiseOctave(p.xz*11 + 0.4*t, 4, 0.6) + noiseOctave(p.xz*15 + 0.1*t, 2, 0.6);
	h = pow(h, 2.0) * 0.5;
	h = 1.0 / (h + 0.4);
	h -= 0.45;
	return  p.y  - h*0.5;
	
	
	//return sea_octave(p.xz, 4.0);
}

float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) 
{
	float t = 0.0;
    const int maxIter = 200;
    
    float material = 0.0;
    
    float d = 0.0;
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;

    	d = map(p);
        if (d < 0.01) {
        	
        	material = 1.0;
        	break;
        }
        t += d;
    }
	finalPos = p;
    return material;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.025, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

float occlusion(vec3 p, vec3 normal)
{
	float o = 0.5*map(p + normal * 2.0).x;
	return o;
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(0.0, 10.0, 0.0);
    vec3 tar = eye + vec3(0.0, -0.6, 1.0);
    
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0.0, 50.0, 30.0);
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    float material = raymarch(ro, rd, finalPos);
    vec3 color = vec3(0.5, 0.5, 0.5);
    vec3 invLight = normalize(light - eye);
    if (material > 0.5) {
    	vec3 normal = getNormal(finalPos);
    	//color = vec3(0.35, 0.65, 1.0) * clamp(finalPos.y * 1.5, 0.75, 1.0);
    	color = color = mix(vec3(15.0, 15.0, 113.0) / 255.0 , vec3(0.35, 0.65, 1.0) * 0.8, clamp(finalPos.y * 3.5, 0.75, 1.0));
    	color *=  occlusion(finalPos, normal);
    	color *= pow(normal.y, 2.0);
	    //vec3 invLight = normalize(light - finalPos);
	    float diffuse = max(0.0, dot(invLight, normal));
	    
	  	color = 0.7 * color * (1.0 + diffuse * 1.0);
	    color += 1.0 * specular(normal, -invLight, normalize(eye - finalPos), 40.0);
    }
    
    fragColor = vec4(color, 1.0);

}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
