#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;

//#define compactKeys  10
//uniform float midi[10 * compactKeys];
uniform float drum;
uniform float incDrum;
//////////////////////////////////////////////////////
vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float length8( vec2 p )
{
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float sdCylinder( vec3 p, float r )
{
  return length(p.xz)-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdSphere( vec3 p, float r)
{
  return length(p)-r;
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

//mat3 rot(float x, float y, float z)
//{
//	float cx = cos(x);
//	float sx = sin(x);
//	float cy = cos(y);
//	float sy = sin(y);
//	float cz = cos(z);
//	float sz = sin(z);
//	mat3 xm = mat3(1, 0, 0,
//					0, cx, -sx,
//					0, sx, cx);
//	mat3 ym = mat3(cy, 0, sy,
//			  		0, 1, 0,
//			  		-sy, 0, cy);
//	mat3 zm = mat3(cz, -sz, 0,
//					sz, cz, 0,
//					0, 0, 1);
//	return xm * ym * zm;
//}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

#define LPOS vec3(0, 2, 0)
vec4 roomLight(vec3 pos) {
	vec3 lightCol = vec3(1,0.8, 0.8);

	float dis = sdSphere(pos - LPOS, 0.1);


	float distanceToL = max(0.0001, dis);
	vec3 point = lightCol * 30.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}

vec4 laser(vec3 p) {
	vec3 lightCol = vec3(1,0.05, 0.05);
	float dx = 2.0;
	int partX = int(p.x / dx);
	p.x = mod(p.x, dx) - dx * 0.5;
	float dz = 4.0;
	p.z = mod(p.z, dz) - dz * 0.5;
	p.y -= -1.3;
//	float music = midi[40 + partX % 10]; // 50 60 20 30
	float music = drum; //2 //44 == hat 45 bas
	float dis = sdCappedCylinder(p.xzy, vec2(0.0, 1.0 * (0.2 + 0.8 * music))) - 0.05;

	float distanceToL = max(0.0001, dis);
	vec3 point = lightCol * 5.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}

vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 r = roomLight(pos);
	vec4 l = laser(pos);
	dis = min(r.w, l.w);
	return r.xyz + l.xyz;
}

void addLightning(inout vec3 color, vec3 normal, vec3 eye, vec3 pos) {

//	vec3 lpos = LPOS;//vec3(1, 1, -2);
	vec3 lpos = LPOS;

	float dis = length(lpos - pos);
	vec3 invLight = normalize(lpos - pos);
	float diffuse = max(0.0, dot(invLight, normal));
	float spec = specular(normal, -invLight, normalize(eye - pos), 70.0);

	float str = 1.0/(0.1 + 0.01*dis + 0.1*dis*dis);
	float tmp = 0;
//	str = 1;
	color =  color * (0.1 + 0.9*diffuse*evaluateLight(pos, tmp).xyz) + spec*str;
//	color = clamp(color, vec3(0), vec3(1));
	//color *= str;
}

float smin( float a, float b)
{
	float k = 0.5;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}
vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);

	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}


//#define TEX 0.2
//#define SIZE 8.0
//#define PI 3.1415

#define MAT_BOX 1.0
#define MAT_GEL 2.0
#define MAT_GROUND 3.0




vec2 gels(vec3 p, inout bool inBox){
	float ttt = iGlobalTime * 1.6;
	float gelDis = 99999;
	float boxDis = 99999;
	float cycle = 14.0;
	float mz = 4.0;
	p.z += 2.0;
	float partZ = floor(p.z / mz);
	float iGlobalTimeZ = ttt + partZ * 3.0;
	float time = mod(iGlobalTimeZ, cycle);

	float t1 = max(0.0, time - 0.5);
	float t2 = time;

	float m = 3.0;

	p.x +=  smoothstep(cycle - 2, cycle, mod(iGlobalTimeZ, cycle)) * m;//max(mod(iGlobalTime, per) - per * 0.5, 0.0);
	float part = floor((p.x) / m);
	p.x = mod(p.x, m) - m * 0.5;


	p.z = mod(p.z, mz) - mz * 0.5;

	float r = 0.3;
	float rt = iGlobalTimeZ;
	float yr = 1.0;
	float cx = 	cos(rt + p.y * yr)*r;
	float cz = 	sin(rt + p.y * yr)*r;
	float s = 1.0;
	float outer = 9999; //mz; //udRoundBox(p, vec3(s), s * 0.1);
	float inner = 9999; //mz; //udRoundBox(p - vec3(0, 1.0, 0), vec3(s * 0.8, s, s * 0.8), s * 0.1);
	float mt = mod(iGlobalTimeZ + 3, 60.0);
	if (partZ == 0.0) {
		outer = length(p - vec3(0, 0.4 , 0)) - 1.2;
		inner = sdCappedCylinder(p - vec3(0, 2.5, 0), vec2(0.0, 2.0)) - 0.9;
	} else if(partZ == 1.0) {
		outer = sdHexPrism(p.xzy - vec3(0, 0, 0), vec2(1.1, 1.1));
		inner = sdHexPrism(p.xzy - vec3(0, 0, 2), vec2(0.9, 2.0));
	} else if (partZ == -1.0) {
		outer = udRoundBox(p, vec3(s), s * 0.1);
		inner = udRoundBox(p - vec3(0, 1.0, 0), vec3(s * 0.8, s, s * 0.8), s * 0.1);
	}
	boxDis = max(-inner, outer);
	if (boxDis > 0.01) {
		inBox = false;

		if (abs(partZ) <= 1.0) {
			t1 -= part * cycle;
			t2 -= part * cycle;
			float dis = p.y - min(t1, 9) * 0.1 + sin(length(p.xz*20.0) - 2*(1-smoothstep(10,12,t2)))*0.03*(1-0.8*smoothstep(8, 12, t2));
			if (inner > 0.01 || length(p.xz-vec2(cx, cz))*2 > t1) {
					dis = 999;
				}
			float dc = sdCappedCylinder(p - vec3(cx, 12 - min(t2 * 3, 2), cz), vec2(0.1, 10.0));
			float h = 3.0 - max(0, t2 - 8);
			if (p.y > h) {
				dc = max(dc,p.y - h);
			}
			gelDis = smink(dis, dc, 1.5);
		}
	}
	return gelDis < boxDis || inBox ? vec2(gelDis, MAT_GEL) : vec2(boxDis, MAT_BOX);
}

vec2 map(vec3 p, inout bool inBox) {
//	vec2 res = ground(p - vec3(0,-2,0), rd);
//	res = un(res, ground(p.xzy - vec3(0,8,0), rd));
//	res = un(res, ground(p.xzy - vec3(0,-8,0), rd));
//	res = un(res, gels(p, inBox));

//	vec2 res = gels(p, inBox);
	vec3 q = mod(p, 1.0) - 0.5;
	q.y = p.y + 2;
	float dis = length(max(abs(q)-vec3(0.3),0.0))- 0.3;

	q = mod(p.xzy, 1.0) - 0.5;
	q.y = p.z - 8;
	dis = min(dis, length(max(abs(q)-vec3(0.3),0.0))- 0.3 );

	q = mod(p.xzy, 1.0) - 0.5;
	q.y = p.z + 8;
	dis = min(dis, length(max(abs(q)-vec3( 0.3),0.0))-  0.3 );

	vec2 res = vec2(dis, MAT_GROUND);
//	float b = udBox(p, vec3(999, 4, 5.5));
//	if (b < 0.01) {
		res = un(res, gels(p, inBox));
//	}
	return res;
}

vec2 map(vec3 p) {
	bool tmp = false;
	return map(p, tmp);
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float occlusion(vec3 p, vec3 normal)
{
	float o = clamp(2*map(p + normal * 0.5).x, 0, 1);
	return fma(0.7, o, 0.3);//0.3 + 0.7*o;
}


#define maxIter 200
#define maxDis 300.0
vec3 raymarch(vec3 ro, vec3 rd, vec3 eye) {
	float t = 0.0;
	float d = 0.0;
//	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 col = vec3(0);
	float ref = 1.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
	bool inBox = false;
	for (int i = 0; i < maxIter; i++) {
		vec3 p = ro + rd * t;
		vec2 res = map(p, inBox);
		d = res.x;
		float fogAmount = 0.005;
		float lightDis = -1.0;
		vec3 light = evaluateLight(p, lightDis);
		d = min(min(d, 1), max(lightDis, 0.05)); // 1 0.05
		vec3 lightIntegrated = light - light * exp(-fogAmount * d);
		scatteredLight += transmittance * lightIntegrated;
		transmittance *= exp(-fogAmount * d);

		t += d;
		float m = res.y;
		if (d < 0.01) {
			vec3 c = vec3(1);
			vec3 normal = getNormal(p);
			if (m == MAT_BOX) {
				c = vec3(0.7, 0.6, 0.4);
			} else if(m == MAT_GEL) {
				if (p.z > 2.0) {
					c = vec3(0.1, 0.8, 0.3);
				} else if (p.z < -2.0) {
					c = vec3(0.9, 0.2, 0.3);
				} else {
					c = vec3(0.3, 0.1, 0.7);
				}
			} else if(m == MAT_GROUND) {
				vec3 fp = floor(p);
				c = texCube(iChannel0, p * 1 + floor(p) * 1.3, normal, 1).xyz * 0.5 + 0.5;
				if (abs(p.z) <= 1 || abs(p.z + 4) <= 1 || abs(p.z - 4) <= 1) {
					c = mix(c, vec3(0.2, 0.5, 0.7), 0.5);
				}
			}
			c *= occlusion(p, normal);
			addLightning(c, normal, eye, p);
			col = mix(col, transmittance * c + scatteredLight, ref);

			inBox = true;
			ref *= 0.8;//0.8
			i = 0;

			if (m != MAT_BOX){
				return col;
			}

			rd = refract(rd, getNormal(p), 1/1.3);
			ro = p + rd*0.05;
			t = 0;
		}
		if (t > maxDis ||  ref < 0.1) {
			return col;
		}
	}

	return col;
}





void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (9.0/ 16.0);//* (iResolution.y/iResolution.x);
    
    float t = iGlobalTime * 0.25;
    vec3 eye = vec3(sin(t) * 3.5, 2.5 + 0.5 * sin(t) , cos(t) * 3.5);
	vec3 tar = vec3(0, 0 , sin(t) * 1.5);//eye + vec3(0.0, 0.0, 1.0);

	float mt = mod(iGlobalTime, 25);
	float tpart = floor(mt / 5.0);
	float tmp = mod(mt, 5.0)*1.5;
	if (tpart == 0.0) {
		eye = vec3(0, 2 + tmp * 0.3, 0);
		tar = vec3(0.1);
	} else if (tpart == 1.0) {
		eye = vec3(0, 3, 1.5 + tmp * 0.2);
		tar = eye + vec3(1,-0.8,0);
	} else if (tpart == 2.0) {
		eye = vec3(4, 3, -3 + tmp * 0.2);
		tar = eye + vec3(-1,-0.8,0.5);
	} else if (tpart == 3.0) {
		eye = vec3(3.5, 2, 6.5 - tmp * 0.2);
		tar = eye + vec3(0,-0.5,-1);
	} else /*if (tpart == 4.0) */{
		vec3 start = vec3(0, 15, 0);
		tar = LPOS + vec3(0.01);//vec3(0.1);
		eye = start  + smoothstep(4, 6, tmp)*(tar - start);
	}


	vec3 dir = normalize(tar - eye);
	float rot = iGlobalTime * 0.5;
	vec3 right = normalize(cross(vec3(0.0, 1.0, 0.0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 0.0, 26.0 );

//	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = -1.0;
	vec3 color = raymarch(ro, rd, eye);

    fragColor = vec4(color, 1.0);
    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
