#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform float drum;
uniform float incDrum;
//////////////////////////////////////////////////////
vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

vec4 modLight(vec3 pos) {

	vec2 d = vec2(2.0);
	pos.z -= iGlobalTime;
	vec2 part = floor((pos.xz + d* 0.5) / d);
	pos.xz = mod(pos.xz, d) - d * 0.5;

	vec3 lightPos = vec3(0.0, -0.3, 0.0);
	vec3 lightCol = vec3(1);
	vec3 L = lightPos-pos;
	float distanceToL = max(0.0001, length(L) -0.01*(0.5 + 1.0*drum));
	vec3 point = lightCol * 0.5/(distanceToL*distanceToL);

	return vec4(point * (0.5 + 1.0*drum), distanceToL);
}



#define LPOS vec3(0, -0.7, 0.5)


vec4 towerLight(vec3 pos) {

	float t = iGlobalTime;
	float tm = t > 13 ? 0.5 : 3;
	vec3 lightCol  = vec3(0.5 + 0.5 * cos(t * 2),0.5 + 0.5 * cos(t * 3),0.5 + 0.5 * cos(t));
			lightCol = normalize(lightCol);
	vec3 lightPos = LPOS;
	vec3 L = lightPos-pos;
	float distanceToL = max(0.0001, length(L));
	vec3 Lnorm = L/distanceToL;
	float dir = max(0.0, dot(Lnorm, vec3(sin(t*tm), 0 , cos(t*tm))));
	float dir2 = max(0.0, dot(Lnorm, -vec3(sin(t*tm), 0 , cos(t*tm))));
	if (dir > dir2) {
		lightCol = vec3(0.5 + 0.5 * sin(t * 2),0.5 + 0.5 * sin(t * 3),0.5 + 0.5 * sin(t));
		lightCol = 1*normalize(lightCol);
	}
	dir = max(dir, dir2);

	vec3 point = lightCol * 50.0/(distanceToL*distanceToL);


	return vec4(point * pow(dir,  10.0), distanceToL);
}

vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 l = towerLight(pos);
	dis = l.w;
	vec4 m = modLight(pos);
	dis = min(l.w, m.w);
	return (l.xyz + m.xyz);
//	return l.xyz;
}

void addLightning(inout vec3 color, vec3 normal, vec3 eye, vec3 pos) {
	vec3 modLightPos = pos;
	vec2 d = vec2(2.0);
	modLightPos.z -= iGlobalTime;
	modLightPos.xz = mod(modLightPos.xz, d) - d * 0.5;
	vec3 invLightModLight = normalize(-modLightPos);
	float diffuseML = max(0.0, dot(invLightModLight, normal));
	float specML = specular(normal, -invLightModLight, normalize(eye - modLightPos), 520.0);

	vec3 lpos = LPOS;//vec3(1, 1, -2);

	float dis = length(lpos - pos);
	vec3 invLight = normalize(lpos - pos);
	float diffuse = max(0.0, dot(invLight, normal));
	float spec = specular(normal, -invLight, normalize(eye - pos), 220.0);

	float str = 1.0/(0.5 + 0.01*dis + 0.1*dis*dis);
	//str = towerLight(pos).x;
	float tmp = 0;
	color =  color * (0.05 + 0.8*diffuse*towerLight(pos).xyz + 0.8*diffuseML*modLight(modLightPos).xyz)
			+ spec*str + specML;
	color = clamp(color, vec3(0), vec3(1));
	//color *= str;
}

float smin( float a, float b)
{
	float k = 0.8;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}
vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);

	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}

mat3 rot(float x, float y, float z)
{
	float cx = cos(x);
	float sx = sin(x);
	float cy = cos(y);
	float sy = sin(y);
	float cz = cos(z);
	float sz = sin(z);
	mat3 xm = mat3(1, 0, 0,
					0, cx, -sx,
					0, sx, cx);
	mat3 ym = mat3(cy, 0, sy,
			  		0, 1, 0,
			  		-sy, 0, cy);
	mat3 zm = mat3(cz, -sz, 0,
					sz, cz, 0,
					0, 0, 1);
	return xm * ym * zm;
}

#define TEX 0.2
#define SIZE 8.0
#define PI 3.1415

#define MAT_WATER 1.0
#define MAT_TOWER 2.0





vec2 water(vec3 p, vec3 rd)
{
	float t = iGlobalTime * 1.5;

	float d = (sin(p.x + t*0.5) + sin(p.z  + t*0.5)) * 0.1 +
			length(texture(iChannel0, p.xz*0.8 + vec2(0, t*0.1)))*0.1 +
			length(texture(iChannel0, p.xz*0.8 + vec2(t*0.13, 0)))*0.1;
	d *= 0.5;

	float h = p.y - d * 0.1;

	float dis = (0.1 -p.y)/rd.y;

	return vec2(max(h, dis), MAT_WATER);
}


vec2 tower(vec3 p) {

	float s = 2.0;
	vec3 q = mod(p, s) - s * 0.5;
	q.y = p.y - 0.3;
	q *= rot(p.y*0.5, iGlobalTime*0.5, p.z*0.8);
//	return vec2(udRoundBox(q, vec3(0.2, 0.5, 0.2), 0.1), MAT_TOWER);
	float a = udRoundBox(q, vec3(0.1, 0.25, 0.1), 0.05);
//	float b = length(q) - 0.5;
	float b = sdCappedCylinder(q, vec2(0.05, 0.5));
	float c = sdTorus(q, vec2(0.25, 0.05));
	float d = sdHexPrism(q, vec2(0.1, 0.025));
	float mt = 1.0;
	float t = mod(iGlobalTime + p.z + p.x + p.y, mt * 5);
	float t1 = smoothstep(mt*0.0, mt*1.0, t);
	float t2 = smoothstep(mt*1.0, mt*2.0, t);
	float t3 = smoothstep(mt*2.0, mt*3.0, t);
	float t4 = smoothstep(mt*3.0, mt*4.0, t);
	float mdis = a*(1.0-t1) + b*t1*(1.0-t2)+ c*t2*(1.0-t3)+ d*t3*(1.0-t4)  + t4*a;
	return vec2(mdis, MAT_TOWER);

}
vec2 map(vec3 p, vec3 rd) {
	vec2 res = water(p - vec3(0, -1.2, 0), rd);
//	res = sunk(res, tower(p - vec3(0,-1.2, iGlobalTime)), 0.2);
	res = sun(res, tower(p - vec3(0,-1.2, iGlobalTime)));
	return res;
}



vec3 getNormal(vec3 p, vec3 rd)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz, rd).x - map(p - ep.xyz, rd).x;
    normal.y = map(p + ep.yxz, rd).x - map(p - ep.yxz, rd).x;
    normal.z = map(p + ep.yzx, rd).x - map(p - ep.yzx, rd).x;
    return normalize(normal);

}

float occlusion(vec3 p, vec3 normal, vec3 rd)
{
	float o = clamp(2*map(p + normal * 0.5, rd).x, 0, 1);
	return 0.2 + 0.8*o;
}



vec3 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos, vec3 eye) {
	float t = 0.0;
	const int maxIter = 45;
	const float maxDis = 50.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 col = vec3(0);
	const int jumps = 3;
	float ref = 1.0;
	vec3 scatteredLight = vec3(0.0);
	float transmittance = 1.0;
	for (int j = 0; j < jumps; j++) {
		for (int i = 0; i < maxIter; i++) {
			p = ro + rd * t;

			vec2 res = map(p, rd);
			d = res.x;
//			d = min(d, 0.2);
			float fogAmount = 0.02;
			float lightDis = -1.0;
			vec3 light = evaluateLight(p, lightDis);
			d = min(d, lightDis);
//			d = min(min(d, 1), max(lightDis, 0.05));
			vec3 lightIntegrated = light - light * exp(-fogAmount * d);
			scatteredLight += transmittance * lightIntegrated;
			transmittance *= exp(-fogAmount * d);

			t += d;
			float m = res.y;
			bool end = i == maxIter - 1 ||t > maxDis;
			if (d < 0.01 || end) {
				vec3 c = vec3(1);
				vec3 normal = getNormal(p, rd);
				if (m == MAT_WATER) {
					c = vec3(0.5, 0.5, 0.9);
					c = vec3(0.1);
				} else if  (m == MAT_TOWER) {
					c = vec3(1,0,0);
//					c = texCube(iChannel1, vec3(p.x, p.y, p.z - iGlobalTime) , normal, 1.0).xyz;
					float tex = texCube(iChannel0, vec3(p.x, p.y, p.z - iGlobalTime) , normal, 1.0).x;
					c = vec3(1-pow(tex, 4.0));
				}
//				c *= occlusion(p, normal, rd);
				addLightning(c, normal, eye, p);
				if (end) {
					transmittance = 0;
				}
				col = mix(col, transmittance * c + scatteredLight, ref);
//				col = mix(col, vec3(0.7), clamp(t * 0.01, 0, 1));
				if (m == MAT_WATER) {
					ref *= 1.0;
				} else {
					ref *= 0.0;
				}
				rd = reflect(rd, getNormal(p, rd));
				ro = p + rd*0.02;
				t = 0;
				break;
			}
			if (t > maxDis) {
				break;
			}
		}

		if (ref < 0.1) {
			break;
		}
	}
	finalPos = p;
	return col;
}





void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0)  * (9.0/ 16.0);//* (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(0, 4 - iGlobalTime * 0.3 , -3.5);
	vec3 tar = vec3(0,0,-1); //eye + vec3(0.0, 0.0, 1.0);
	if (iGlobalTime > 21) {
		eye = vec3(1,-0.3,0);
		tar = eye + vec3(0, 0, -1);
	} else if (iGlobalTime > 13) {
		eye = LPOS + vec3(0, 0.5, 0);
		float t = iGlobalTime * 0.5;
		tar = eye + vec3(sin(t), 0, cos(t));
	} else if (iGlobalTime > 5.0) {
		vec3 c = vec3(1,-0.5,iGlobalTime - 10.5);
		float r = 0.2;
		float t = 0.0;
		eye = c + vec3(sin(iGlobalTime * t) * r, 0.2 , cos(iGlobalTime * t) * r);
		tar = c;
	}

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 0.0, 26.0 );

	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = -1.0;
	vec3 color = raymarch(ro, rd, finalPos, eye);
	color = mix(color, vec3(1), smoothstep(26.5, 26.9, iGlobalTime));
    fragColor = vec4(color, 1.0);
//    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
