/*
              MANKALLE TEHTY KÄYTTÖOHJELMA, MUOKATTU 
              NÄYTÖN AJUREIDEN ESITTELYOHJELMASTA
              HEADERIT JÄTETTY ALAPUOLELLE REFERENSSEJÄ VARTEN


              Efektit koodattu itse, fft tehdään arm-sirun rautafunktiolla, esimerkit kopioitu adafruitin sivuilta, ja muokattu omaan käyttöön
              sopiviksi. 

              Käytössä esimerkkien grafiikkaprimitiivit kuten spritet, linet ja pikselit. 
              Näytön bufferiin kirjoittaminen ei toiminut tällä näytöllä jostain syystä, tähän pitää perehtyä jatkossa tarkemmin
              nyt keskityttiin lähinnä laitteen toimintakuntoiseksi saamiseen. 

              
              TODO:
                -jännitteen ja virran kalibrointi (kalibroitu nopeasti, lähinnä sinnepäin :D )
                -rotary encoderin käyttöönotto sivujen hallintaan
                -bluetooth-palikan virran ohjaus (nyt säädetty kokonaan päälle)
                -akun vaihto lipoon, ohjauselektroniikka ei ehtinyt saapua kiinasta
                -pitkän ajan keskiarvo virralle, akun kapasiteettiin perustuva käyttöaika 
                -kello
                -parempi step-down regulaattori, nykyinen mekkaloi 5v railiin

              Kaikki laitteet koottu protolevylle, viivaversiolle. Viivoja katkottu sitten sopivista kohtaa dremelillä.
              Käytössä kolme eri jännitettä, vahvistin käyttää 12v suoraan akulta, teensylle, näytölle ja bluetooth-modulille
              menee 5v raili, tosin tähän railiin tulee möykkää joko näytöltä tai sitten regulaattorilta.
              3.3v raili otetaan teensyn regulaattorista ja käytetään audiosignaalin dc-shiftiin teensylle sopivaksi, 
              analogipinnit lukevat pelkästään positiivista jännitettä, ja audiosignaali on normaalisti + ja -. 

              Käytössä olleet moduulit:
                -ta2020 valmis vahvistinmoduli (d-luokkalainen, hyvä hyötysuhde) 
                -kiinalainen step-down regulaattori (12v->5v)
                -MAX471 virta ja jänniteanturi arduinolle
                -krc-86b bluetooth audio moduli
                -eastrising 256x64 16 sävyn keltainen oled-näyttö

              Kaiutin on seasin koaksiaali 18cm halkaisijaltaan, peräisin hifitalosta, vahvistimen 
              molemmat kanavat käytössä, vaikka mankka onkin monolaite. Vasen kanava menee bassoelementtiin
              oikea kanava menee diskanttielementtiin.

              Kotelo on tehty mäntyliimapuulevystä, vaneri olisi ollut parempi materiaali mutta sitä ei myydä 
              tarpeeksi pieninä paloina, tähän kului 1 iso 18mm liimapuulevy. 

              Virran antaa biltemasta ostettu 3.0 Ah:n geeliakku, vaihdetaan lipoon myöhemmin, tämä on painava ja iso.

              
              
              
*/
/**
   This is an example for the Newhaven NHD-3.12-25664UCY2 OLED based on SSD1322 drivers
   The NHD-3.12-25664UCY2 is sold through Digikey and Mouser

   Following hardware connections are assumed

     OLED                   Arduino 101
     ---------------------+------------------------------------------------------------------
     #1 Vss/GND             GND
     #2 Vdd                 3V3 (up to 271 mA, use external power supply to feed Arduino 101)
     #4 D/!C                D9
     #7 SCLK                D13 (hardware SPI SCLK)
     #8 SDIN                D11 (hardware SPI MOSI)
     #16 !RESET             !RESET
     #17 !CS                D10
     #5,#6,#10-14,#19,#20   GND
     #3,#9,#15,#18          not connected

   Based on Adafruit SSD1306 driver (https://github.com/adafruit/Adafruit_SSD1306)
     for which the original header is left below:
*/


/*********************************************************************
  This is a library for the 256 x 64 pixel 16 color gray scale OLEDs
  based on SSD1322 drivers

  These displays use SPI to communicate, 4 or 5 pins are required to
  interface

  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Written by Limor Fried/Ladyada  for Adafruit Industries.
  BSD license, check license.txt for more information
  All text above, and the splash screen must be included in any redistribution
*********************************************************************/


#define ARM_MATH_CM4
#include <arm_math.h>
#include <SPI.h>
//#include <Adafruit_GFX.h>
#include <ESP8266_SSD1322.h>

//ESP8266 Pins
//#define OLED_CS     15  // Pin 19, CS - Chip select
//#define OLED_DC     2   // Pin 20 - DC digital signal
//#define OLED_RESET  16  // Pin 15 -RESET digital signal

//Arduino_101 Pins
#define OLED_CS     10  // Pin 10, CS - Chip select
#define OLED_DC     9   // Pin 9 - DC digital signal
#define OLED_RESET  8   // using hardware !RESET from Arduino instead

// ATMega32u4 pins
//#define OLED_DC    8 //  D8  - B4
//#define OLED_CS    17 // D17 - B0
//#define OLED_RESET 9  // D9  - B5

//hardware SPI - only way to go. Can get 110 FPS
ESP8266_SSD1322 display(OLED_DC, OLED_RESET, OLED_CS);

#define NUMFLAKES 256
#define XPOS 0
#define YPOS 1
#define ZPOS 2
#define COLOR 3

////////////////////////////////////////////////////////////////////////////////
// CONIFIGURATION
// These values can be changed to alter the behavior of the spectrum display.
////////////////////////////////////////////////////////////////////////////////

int SAMPLE_RATE_HZ = 11200;             // Sample rate of the audio in hertz.
// Useful for turning the LED display on and off with commands from the serial port.
const int FFT_SIZE = 64;              // Size of the FFT.  Realistically can only be at most 256
// without running out of memory for buffers and other state.
const int AUDIO_INPUT_PIN = 23;        // Input ADC pin for audio data.
const int ANALOG_READ_RESOLUTION = 10; // Bits of resolution for the ADC.
const int ANALOG_READ_AVERAGING = 2;  // Number of samples to average with each ADC reading.

///// seuraavat wormholen parametreja
const int YMPYROITA = 32;
const int  PISTEITA_YMPYRASSA = 32;
const int SADE = 150; // ympyran säde wormholea varten
//const int SADE_KERROIN = 20; // pikseleita
const int LISSAJOUS_KERROIN = 150; // pikseleita
////////////////////////////////////////////////////////////////////////////////
// INTERNAL STATE
// These shouldn't be modified unless you know what you're doing.
////////////////////////////////////////////////////////////////////////////////

IntervalTimer samplingTimer;
float samples[FFT_SIZE * 2];
float magnitudes[FFT_SIZE];
int sampleCounter = 0, nappiaika=0;
uint64_t framecounter = 0;
boolean bluetooth = 1, nappi = 0, nappi_last = 0, ra = 0, rb = 0, ra_last = 0, rb_last = 0;
uint8_t page = 0; //99 on demo mode



const unsigned char tsr [] = {
  0xFD, 0xFB, 0xE0, 0x31, 0x83, 0x00, 0x31, 0x83, 0x00, 0x31, 0xFB, 0x00, 0x30, 0x1B, 0x00, 0x30,
  0x1B, 0x00, 0x31, 0xFB, 0x00, 0x00, 0x00, 0x00,
};

const unsigned char  hukka [] = {
  0xCD, 0x9B, 0x36, 0x6F, 0xC0, 0xCD, 0x9B, 0x36, 0x6C, 0xC0, 0xCD, 0x9B, 0x26, 0x4C, 0xC0, 0xFD,
  0x9B, 0xC7, 0x8F, 0xC0, 0xCD, 0x9B, 0x26, 0x4C, 0xC0, 0xCD, 0x9B, 0x36, 0x6C, 0xC0, 0xCD, 0xFB,
  0x36, 0x6C, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
};


const unsigned char  exec [] = {
  0xFD, 0x9B, 0xF7, 0xE0, 0xC1, 0x9B, 0x06, 0x00, 0xC0, 0x93, 0x06, 0x00, 0xFC, 0x63, 0xF6, 0x00,
  0xC0, 0x93, 0x06, 0x00, 0xC1, 0x9B, 0x06, 0x00, 0xFD, 0x9B, 0xF7, 0xE0, 0x00, 0x00, 0x00, 0x00
};

const unsigned char boozembly [] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x31, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x31, 0x80, 0x00,
  0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 0x31, 0x80, 0x60, 0x00, 0x00, 0x03, 0x00, 0x01, 0x80, 0x33,
  0x00, 0x60, 0x07, 0xFC, 0x03, 0x00, 0x03, 0xC0, 0x26, 0x00, 0x60, 0x1F, 0xFE, 0x06, 0x70, 0x06,
  0x60, 0x2C, 0x00, 0x60, 0x38, 0x03, 0x0C, 0x78, 0x1E, 0x60, 0x18, 0x00, 0x60, 0x00, 0x63, 0x18,
  0x6C, 0x3E, 0x60, 0x30, 0x00, 0x6F, 0xF8, 0x63, 0x30, 0x66, 0x66, 0x60, 0xE0, 0x00, 0x6F, 0xFE,
  0x63, 0x60, 0x63, 0x66, 0x6F, 0xD0, 0x00, 0x67, 0x06, 0x63, 0x63, 0xFF, 0x66, 0x6F, 0xB0, 0xC6,
  0x63, 0x63, 0x63, 0x63, 0xFF, 0x66, 0x66, 0x30, 0xC6, 0x63, 0x63, 0x63, 0x63, 0x60, 0x66, 0x63,
  0x31, 0xC6, 0x63, 0x63, 0x63, 0x63, 0x60, 0x66, 0x61, 0xB1, 0xC6, 0x63, 0x63, 0x63, 0x63, 0x60,
  0x66, 0x61, 0x9B, 0xC6, 0x63, 0x63, 0x63, 0x63, 0x60, 0xC6, 0x63, 0x1B, 0x6E, 0x36, 0x63, 0x36,
  0x36, 0x31, 0xC6, 0x33, 0x0E, 0x6E, 0x36, 0x63, 0x36, 0x36, 0x3F, 0x86, 0x36, 0x0E, 0x3E, 0x1C,
  0x63, 0x1C, 0x1C, 0x0E, 0x06, 0x1C, 0x04, 0x16, 0x1C, 0x36, 0x1C, 0x1C, 0x00, 0x00, 0x1C, 0x00,
  0x06, 0x08, 0x36, 0x08, 0x08, 0x00, 0x00, 0x08, 0x00, 0x06, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6C, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char assembly [] = {
  0x3F, 0x07, 0xF8, 0xFF, 0x3F, 0xE3, 0xF7, 0xE3, 0xFC, 0x70, 0x38, 0xE0, 0x7F, 0x8F, 0xF9, 0xFF,
  0x7F, 0xE7, 0xFF, 0xF3, 0xFE, 0x70, 0x38, 0xE0, 0xE1, 0xDE, 0x03, 0xC0, 0x70, 0x0E, 0x1C, 0x3B,
  0x8F, 0x70, 0x38, 0xE0, 0xE1, 0xDC, 0x03, 0x80, 0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x38, 0xE0,
  0xE1, 0xDC, 0x03, 0x80, 0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x38, 0xE0, 0xE1, 0xDC, 0x03, 0x80,
  0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x38, 0xE0, 0xE1, 0xDC, 0x03, 0x80, 0x70, 0x0E, 0x1C, 0x3B,
  0x87, 0x70, 0x38, 0xE0, 0xFF, 0xDF, 0xF3, 0xFE, 0x7F, 0xEE, 0x1C, 0x3B, 0xFF, 0x70, 0x3D, 0xE0,
  0xFF, 0xDF, 0xFB, 0xFF, 0x7F, 0xEE, 0x1C, 0x3B, 0xFE, 0x70, 0x1F, 0xC0, 0xFF, 0xCF, 0xF9, 0xFF,
  0x7F, 0xEE, 0x1C, 0x3B, 0xFF, 0x70, 0x0F, 0x80, 0xE1, 0xC0, 0x38, 0x07, 0x70, 0x0E, 0x1C, 0x3B,
  0x87, 0x70, 0x07, 0x00, 0xE1, 0xC0, 0x38, 0x07, 0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x07, 0x00,
  0xE1, 0xC0, 0x38, 0x07, 0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x07, 0x00, 0xE1, 0xC0, 0x38, 0x07,
  0x70, 0x0E, 0x1C, 0x3B, 0x87, 0x70, 0x07, 0x00, 0xE1, 0xC0, 0x78, 0x0F, 0x70, 0x0E, 0x1C, 0x3B,
  0x8F, 0x70, 0x07, 0x00, 0xE1, 0xDF, 0xF3, 0xFE, 0x7F, 0xEE, 0x1C, 0x3B, 0xFE, 0x7F, 0xE7, 0x00,
  0xE1, 0xDF, 0xE3, 0xFC, 0x3F, 0xEE, 0x1C, 0x3B, 0xFC, 0x7F, 0xE7, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xD0, 0x9B, 0x1B, 0x1E, 0xF0,
  0x2F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0xA4, 0xA4, 0xA0, 0x88, 0x20, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x10, 0xA4, 0xA4, 0xA0, 0x88, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xD0,
  0xA4, 0xA4, 0xBE, 0x88, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xA4, 0xA4, 0xA0, 0xF0,
  0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xA4, 0xA4, 0xA0, 0x88, 0x24, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x8F, 0x24, 0xA4, 0x9E, 0x88, 0x28, 0x00, 0x00, 0x00,
};


//#if (SSD1322_LCDHEIGHT != 64)
//#error("Height incorrect, please fix ESP8266_SSD1322.h!");
//#endif

void setup()   {
  //Serial.begin(9600);
  // Initialize and perform reset
  display.begin(true);
  // init done
  // display.setRotation(2);

  display.setTextColor(15);
  display.setTextSize(1);
  display.dim(0);

  pinMode(AUDIO_INPUT_PIN, INPUT);
  analogReadResolution(ANALOG_READ_RESOLUTION);
  analogReadAveraging(ANALOG_READ_AVERAGING);

  pinMode(3, INPUT);
  pinMode(4, INPUT);
  pinMode(5, INPUT);
  pinMode(1, OUTPUT);
  digitalWrite(1, !bluetooth); //bluetooth päälle
  // Begin sampling audio
  samplingBegin();

}


void loop() {
  
  if (page == 99) {
    framecounter = 0;
    starfield_z(2000);
    framecounter = 0;
    wormhole(1800);
    framecounter = 0;
    starfield_x_demo(1800);
    page = 0; //defaultnäyttö on starfield mutta ei tekstejä
  }
  starfield_x(0);

}
int nappihandleri() {
  nappi = digitalRead(3);
  if (nappi==1) { 
    nappi_last = 1;
    nappiaika=framecounter;
  }
  if (nappi==0 && nappi_last==1 && nappiaika+50<framecounter) {
    nappi_last=0;
    return 1;
  } else {
    return 0;
  }
}

void starfield_x(uint16_t frames) {
  int16_t icons[NUMFLAKES][4] , arvo, dat;
  double average, old_average;
  float x, y;
  uint8_t  z, window[FFT_SIZE * 2], spectrum_peak[FFT_SIZE / 2];
  uint16_t cc, dc, i, d, old_x, f, jannite=0, virta=0;;
  // initialize
  jannite=analogRead(22);
  virta=analogRead(21);
  display.setTextColor(15);
  for (f = 0; f < NUMFLAKES; f++) {
    icons[f][XPOS] = random(8096) - 1048;
    icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
    icons[f][ZPOS] = random(256);
    icons[f][COLOR] = random(15) + 1;
  }
  cc = 0; dc = 0; arvo = 0;
  for (i = 0; i < FFT_SIZE * 2; i++) {
    x = sin(3.14159 * i / (FFT_SIZE * 2 - 2));
    x = x * x * 256;
    window[i] = x;
  }
  for (i = 0; i < (FFT_SIZE / 2) - 1; i++) {
    spectrum_peak[i] = 1;
  }
  old_average = 770;
  while (nappihandleri()==0) {
    framecounter++;


    //if (color > 60 || color < 20) dc = -dc;

    average = 0;
    old_x = old_average;
    for (i = 1; i < FFT_SIZE; i++) {
      x = samples[i * 2];
      average += x;
      x -= old_average;
      x /= 12;
      x += 32;
      if (x < 1) x = 1;
      if (x > 63) x = 63;

      //display.drawPixel(i*4,(int)x,1);
      //display.drawPixel(i*4+1,(int)x,1);

      if (i > 1) display.drawLine(i * 4, (int)x, (i - 1) * 4, old_x, 3); //////////////////////////// oskilloskooppi piirretään ennenkuin ikkunoidaan samplet
      old_x = (int)x;
      samples[i * 2] *= 1 + window[i] / 256; ///////////////////////////////////// Ikkunafunktio sampleille fft:tä varten
    }
    old_average = average / 64;
    if (samplingIsDone()) do_sampling();
    ///////////////////////////////////////////
    // PIIRRÄ SPEKTRI
    //////////////////////////////////////////
    for (i = 1; i < (FFT_SIZE / 2) - 1; i++) {
      x = magnitudes[i];
      x = sqrt(x * x);
      x = sqrt(x);
      //x-=25;
      x /= 2;

      if (x < 1) x = 1;
      if (x > 63) x = 63;
      //x=63-x;
      d = ((i - 2) * 8) + 18;
      /*
        display.drawPixel(d,(int)x,10);
        display.drawPixel(d+1,(int)x,10);
        display.drawPixel(d+2,(int)x,10);
        display.drawPixel(d+3,(int)x,10);
      */
      if (cc % 5 == 0) spectrum_peak[i]--;
      if (spectrum_peak[i] < (int)x) spectrum_peak[i] = (int)x;
      display.drawFastVLine(d, 63 - (int)x, (int)x , 1);
      display.drawFastVLine(d + 1, 63 - (int)x, (int)x , 1);
      display.drawFastVLine(d + 2, 63 - (int)x, (int)x , 1);
      display.drawFastHLine(d, 63 - spectrum_peak[i], 3, 10);
    }
    /*
      display.setCursor(0,0);
      display.print(average/64);
    */
    // dc=4;

    for (f = 0; f < NUMFLAKES; f++) {
      z = icons[f][ZPOS];
      x = icons[f][XPOS] * 20;
      x /= z;
      x += 128;
      y = icons[f][YPOS] * 20;
      y /= z;
      y += 32;

      if (x >= 0 && y < 64 && y >= 0 && z > 0)    {
        if (x < 256) display.drawPixel((int)x, (int)y, (icons[f][COLOR] * (255 - z)) / 256);
        //   display.drawPixel((int)x,(int)y,15);

        icons[f][XPOS] -= 5;
      } else {
        icons[f][ZPOS] = random(256);
        icons[f][XPOS] = random(2048) + 1024; //random(6 * display.width()) - 3 * display.width();
        icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
        icons[f][COLOR] = random(15) + 1;
      }
    }
    cc++;


    if (cc > 20) {
    jannite=analogRead(22);
  
    virta=analogRead(21);
      cc = 0;
    }
    //if (dc == 6) dc = 0;
    //dc = 0;
    display.setCursor(5,5);
    display.print("Voltage: ");
    display.print((float)jannite/39);
    display.print(" V");
    display.setCursor(5,18);
    display.print("Current: ");
    display.print(virta*4.5);
    display.print(" mA");
    display. setCursor(140,5);
    display.print("Power: ");
    display.print((float)(virta*4.5)/1000*(jannite/39));
    display.print(" W");
    display.display();
    display.clearDisplay();
  }
  page=99;
}
/////////////////////////////////////////////////////////////////////////////// DEMO ALKAA /////////////////////////////////////////////////////////////////////////////// DEMO ALKAA /////////////////////////////////////////////////////////////////////////////// DEMO ALKAA 
void starfield_x_demo(uint16_t frames) {
  int16_t icons[NUMFLAKES][4] , arvo, dat;
  double average, old_average;
  float x, y;
  uint8_t  z, window[FFT_SIZE * 2], spectrum_peak[FFT_SIZE / 2];
  uint16_t cc, dc, i, d, old_x, f;
  // initialize
  display.setTextColor(15);
  for (f = 0; f < NUMFLAKES; f++) {
    icons[f][XPOS] = random(8096) - 1048;
    icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
    icons[f][ZPOS] = random(256);
    icons[f][COLOR] = random(15) + 1;
  }
  cc = 0; dc = 0; arvo = 0;
  for (i = 0; i < FFT_SIZE * 2; i++) {
    x = sin(3.14159 * i / (FFT_SIZE * 2 - 2));
    x = x * x * 256;
    window[i] = x;
  }
  for (i = 0; i < (FFT_SIZE / 2) - 1; i++) {
    spectrum_peak[i] = 1;
  }
  old_average = 770;
  while (framecounter < frames) {
    framecounter++;
  if(nappihandleri()==1) framecounter=99999; /// poistu loopista
   

    //if (color > 60 || color < 20) dc = -dc;

    average = 0;
    old_x = old_average;
    for (i = 1; i < FFT_SIZE; i++) {
      x = samples[i * 2];
      average += x;
      x -= old_average;
      x /= 12;
      x += 32;
      if (x < 1) x = 1;
      if (x > 63) x = 63;

      //display.drawPixel(i*4,(int)x,1);
      //display.drawPixel(i*4+1,(int)x,1);

      if (i > 1) display.drawLine(i * 4, (int)x, (i - 1) * 4, old_x, 3); //////////////////////////// oskilloskooppi piirretään ennenkuin ikkunoidaan samplet
      old_x = (int)x;
      samples[i * 2] *= 1 + window[i] / 256; ///////////////////////////////////// Ikkunafunktio sampleille fft:tä varten
    }
    old_average = average / 64;
    if (samplingIsDone()) do_sampling();
    ///////////////////////////////////////////
    // PIIRRÄ SPEKTRI
    //////////////////////////////////////////
    for (i = 1; i < (FFT_SIZE / 2) - 1; i++) {
      x = magnitudes[i];
      x = sqrt(x * x);
      x = sqrt(x);
      //x-=25;
      x /= 2;

      if (x < 1) x = 1;
      if (x > 63) x = 63;
      //x=63-x;
      d = ((i - 2) * 8) + 18;
      /*
        display.drawPixel(d,(int)x,10);
        display.drawPixel(d+1,(int)x,10);
        display.drawPixel(d+2,(int)x,10);
        display.drawPixel(d+3,(int)x,10);
      */
      if (cc % 5 == 0) spectrum_peak[i]--;
      if (spectrum_peak[i] < (int)x) spectrum_peak[i] = (int)x;
      display.drawFastVLine(d, 63 - (int)x, (int)x , 1);
      display.drawFastVLine(d + 1, 63 - (int)x, (int)x , 1);
      display.drawFastVLine(d + 2, 63 - (int)x, (int)x , 1);
      display.drawFastHLine(d, 63 - spectrum_peak[i], 3, 10);
    }
    /*
      display.setCursor(0,0);
      display.print(average/64);
    */
    // dc=4;

    for (f = 0; f < NUMFLAKES; f++) {
      z = icons[f][ZPOS];
      x = icons[f][XPOS] * 20;
      x /= z;
      x += 128;
      y = icons[f][YPOS] * 20;
      y /= z;
      y += 32;

      if (x >= 0 && y < 64 && y >= 0 && z > 0)    {
        if (x < 256) display.drawPixel((int)x, (int)y, (icons[f][COLOR] * (255 - z)) / 256);
        //   display.drawPixel((int)x,(int)y,15);

        icons[f][XPOS] -= 5;
      } else {
        icons[f][ZPOS] = random(256);
        icons[f][XPOS] = random(2048) + 1024; //random(6 * display.width()) - 3 * display.width();
        icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
        icons[f][COLOR] = random(15) + 1;
      }
    }
    cc++;


    if (cc > 40) {
      dc++;
      cc = 0;
    }
    //if (dc == 6) dc = 0;
    //dc = 0;
    switch (dc) {
      default: {
          display.setCursor(83, 28);
          if (dc < 20) display.print("-- we greet --"); //15 merkkiä       keskikohta 104, 28

        } break;
      case 11: {
          display.setCursor(104, 28);
          display.print("Division"); // 8 merkkiä     keskikohta 89, 26
        } break;
      case 12: {
          display.setCursor(104, 28); // 8 merkkiä     keskikohta 119, 26
          display.print("Pyrotech");
        } break;
      case 13: {
          display.setCursor(119, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("RRE");
        } break;
      case 14: {
          display.setCursor(116, 28); // 4 merkkiä     keskikohta 119, 26
          display.print("Void");
        } break;

      case 15: {
          display.setCursor(83, 28); // 15 merkkiä     keskikohta 119, 26
          display.print("-- we admire --");
        } break;

      case 16: {
          display.setCursor(119, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("ASD");
        } break;
      case 17: {
          display.setCursor(101, 28); // 9 merkkiä     keskikohta 119, 26
          display.print("Fairlight");
        } break;
      case 18: {
          display.setCursor(119, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("MFX");
        } break;
      case 19: {
          display.setCursor(107, 28); // 7 merkkiä     keskikohta 119, 26
          display.print("Kewlers");
        } break;
      case 20: {
          display.setCursor(116, 28); // 4 merkkiä     keskikohta 119, 26
          display.print("CNCD");
        } break;
      case 21: {
          display.setCursor(119, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("PWP");
        } break;
      case 22: {
          display.setCursor(71, 28); // 19 merkkiä     keskikohta 119, 26
          display.print("THANKS FOR WATCHING");
          display.setCursor(119, 38); // 3 merkkiä     keskikohta 119, 26

          display.print("bye");

        } break;
      case 23: {
          display.setCursor(71, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("THANKS FOR WATCHING");
          display.setCursor(119, 38); // 3 merkkiä     keskikohta 119, 26

          display.print("bye");

        } break;
      case 24: {
          display.setCursor(71, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("THANKS FOR WATCHING");
          display.setCursor(119, 38); // 3 merkkiä     keskikohta 119, 26

          display.print("bye");

        } break;

    }
    display.display();
    display.clearDisplay();
  }
}



void wormhole(uint16_t frames) {
  int16_t icons[YMPYROITA][PISTEITA_YMPYRASSA][4], f, z, k, dc = 0, cc = 0;

  float x, y, df, ympyra_x[PISTEITA_YMPYRASSA], ympyra_y[PISTEITA_YMPYRASSA];
  // initialize
  df = (2 * PI ) / (float) PISTEITA_YMPYRASSA;
  for (z = 0; z < PISTEITA_YMPYRASSA; z++) {
    ympyra_x[z] = sin(df * z );
    ympyra_y[z] = cos(df * z );

  }

  for (z = 0; z < YMPYROITA; z++) {
    framecounter++;


    for (f = 0; f < PISTEITA_YMPYRASSA; f++) {

      icons[z][f][XPOS] = ympyra_x[f] * (SADE - k) + sin(framecounter / 60.0) * LISSAJOUS_KERROIN;
      icons[z][f][YPOS] = ympyra_y[f] * (SADE - k) + cos(framecounter / 39.0) * LISSAJOUS_KERROIN;
      icons[z][f][ZPOS] = z * (256 / YMPYROITA);
      icons[z][f][COLOR] = 15;
    }
  }
  while (framecounter < frames) {
    framecounter++;
    if(nappihandleri()==1) framecounter=99999; /// poistu loopista
    // draw each icon
    //display.setCursor(0,0);
    //display.print(icons[0][0][ZPOS]);
    for (z = 0; z < YMPYROITA; z++) {
      if (icons[z][1][ZPOS] > 3) {
        for (f = 0; f < PISTEITA_YMPYRASSA; f++) {
          // display.drawBitmap(icons[f][XPOS], icons[f][YPOS], logo16_glcd_bmp, w, h, icons[f][COLOR]);
          k = icons[z][f][ZPOS];
          x = icons[z][f][XPOS] * 20;
          x /= k;
          x += 128;
          y = icons[z][f][YPOS] * 20;
          y /= k;
          y += 32;

          if (k >= 1)    {
            //display.drawPixel((int)x, (int)y, (icons[f][COLOR] * (255 - icons[f][ZPOS])) / 256);
            if (x < 256 && x >= 0 && y < 64 && y >= 0) display.drawPixel((int)x, (int)y, (256 - k) / 16);

            icons[z][f][ZPOS] -= 3;
          }
        }
      } else {
        x = FFT_SIZE / PISTEITA_YMPYRASSA;
        for (f = 0; f < PISTEITA_YMPYRASSA; f++) {
          k = (samples[(int)(x * f) % (FFT_SIZE - 1)] - 770) / 2;
          //       icons[z][f][XPOS] = ympyra_x[f] * SADE*(samples[f%(FFT_SIZE-1)]-770)/12 + sin(framecounter / 60.0) * LISSAJOUS_KERROIN;
          //      icons[z][f][YPOS] = ympyra_y[f] * SADE* (samples[f%(FFT_SIZE-1)]-770)/12 + cos(framecounter / 39.0) * LISSAJOUS_KERROIN;
          icons[z][f][XPOS] = ympyra_x[f] * (SADE - k) + sin(framecounter / 60.0) * LISSAJOUS_KERROIN;
          icons[z][f][YPOS] = ympyra_y[f] * (SADE - k) + cos(framecounter / 39.0) * LISSAJOUS_KERROIN;

          icons[z][f][ZPOS] = 256;
          //icons[z][f][COLOR] = 15;
        }
      }
    }
    cc++;


    if (cc > 200) {
      dc++;
      cc = 0;
    }
    //if (dc == 6) dc = 0;
    //dc = 1;
    switch (dc) {
      case 0:  {


        } break;
      case 1: {
          display.setTextColor(6);
          display.drawBitmap(20, 12, tsr, 24, 8, 15); //tsr_exec map 56x8, keskikohta 100,24
          display.drawBitmap(200, 12, hukka, 40, 8, 15); //tsr_exec map 40x8, keskikohta 100,24


        } break;
      case 2: {
          display.drawBitmap(20, 12, tsr, 24, 8, 15); //tsr_exec map 56x8, keskikohta 100,24
          display.drawBitmap(200, 12, hukka, 40, 8, 15); //tsr_exec map 40x8, keskikohta 100,24

          display.setCursor(20, 24);
          display.setTextColor(6);
          display.print("hardware");
          display.setCursor(20, 34);
          display.print("software");
          display.setCursor(20, 44);
          display.print("woodware");

        } break;
      case 3: {
          display.drawBitmap(20, 12, tsr, 24, 8, 15); //tsr_exec map 56x8, keskikohta 100,24
          display.drawBitmap(200, 12, hukka, 40, 8, 15); //tsr_exec map 40x8, keskikohta 100,24

          display.setCursor(20, 24);
          display.setTextColor(6);
          display.print("hardware");
          display.setCursor(20, 34);
          display.print("software");
          display.setCursor(20, 44);
          display.print("woodware");

          display.setCursor(205, 22);
          display.print("music");
          display.setCursor(193, 32);
          display.print("tickets");

        } break;
      case 4: {
          // display.drawBitmap(92, 16, boozembly, 72, 32, 15); //boozembly 72x32     keskikohta 72, 32
        } break;
      case 5: {
        } break;
    }
    if (samplingIsDone()) do_sampling();
    display.display();
    // delay(200);
    display.clearDisplay();
  }
}




void starfield_z(uint16_t frames) {
  int16_t icons[NUMFLAKES][4], f, dc, cc;
  float x, y;

  // initialize
  for (f = 0; f < NUMFLAKES; f++) {
    icons[f][XPOS] = random(6 * display.width()) - 3 * display.width();
    icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
    icons[f][ZPOS] = random(256);
    icons[f][COLOR] = random(15) + 1;
  }
  cc = -100; dc = -1;
  while (framecounter < frames) {
    framecounter++;
      if(nappihandleri()==1) framecounter=99999; /// poistu loopista
   
    // draw each icon
    for (f = 0; f < NUMFLAKES; f++) {
      // display.drawBitmap(icons[f][XPOS], icons[f][YPOS], logo16_glcd_bmp, w, h, icons[f][COLOR]);
      x = icons[f][XPOS] * 20;
      x /= icons[f][ZPOS];
      x += 128;
      y = icons[f][YPOS] * 20;
      y /= icons[f][ZPOS];
      y += 32;

      if (x < 256 && x >= 0 && y < 64 && y >= 0 && icons[f][ZPOS] > 1)    {
        if (cc >= 0)   display.drawPixel((int)x, (int)y, (icons[f][COLOR] * (255 - icons[f][ZPOS])) / 256);
        if (cc < 0)    display.drawPixel((int)x, (int)y, (int)((icons[f][COLOR] * (255 - icons[f][ZPOS])) / 256 * (float)((100 + cc)) / 100));

        icons[f][ZPOS]--;
      } else {
        icons[f][ZPOS] = 255;
        icons[f][XPOS] = random(6 * display.width()) - 3 * display.width();
        icons[f][YPOS] = random(6 * display.height()) - 3 * display.height();
        icons[f][COLOR] = random(15) + 1;
      }
    }
    cc++;


    if (cc > 300) {
      dc++;
      cc = 0;
    }
    if (dc == 6) dc = 0;
    //dc = 3;
    switch (dc) {
      case 0:  {
          display.drawBitmap(114, 24, exec, 32, 8, 15); //tsr_exec map 29x8, keskikohta 114,29
          display.setCursor(104, 33);
          display.print("presents");  //8 merkkiä       keskikohta 104, 26
          /*
            display.drawBitmap(100, 29, tsr_exec, 56, 8, 15); //tsr_exec map 56x8, keskikohta 100,29
            display.drawBitmap(110, 29, hukka, 40, 8, 15); //tsr_exec map 36x8, keskikohta 110,29
            display.drawBitmap(114, 49, exec, 32, 8, 15); //tsr_exec map 29x8, keskikohta 114,29
          */
        } break;
      case 1: {
          display.setCursor(89, 28);
          display.print("Mankka v. 3.0"); // 13 merkkiä     keskikohta 89, 26

        } break;

      case 2: {
          display.setCursor(119, 28); // 3 merkkiä     keskikohta 119, 26
          display.print("for");

        } break;
      case 3: {
          if (cc < 20) {
            display.drawBitmap(92, 16, boozembly, 72, 32, 15); //boozembly 72x32     keskikohta 72, 32
          } else   display.drawBitmap(82, 22, assembly, 92, 25, 15); //tsr_exec map 29x8, keskikohta 114,29
        } break;
      case 4: {
          display.drawBitmap(82, 22, assembly, 92, 25, 15); //tsr_exec map 29x8, keskikohta 114,29
        } break;
      case 5: {
        } break;
    }
    display.display();
    // delay(200);
    display.clearDisplay();

  }
}
///////////////////////////////////////////
// sämpläysfunktiot kopsittu adafruitin tutoriaalista
//////////////////////////////////////////
void do_sampling() {
  // Run FFT on sample data.

  arm_cfft_radix4_instance_f32 fft_inst;
  arm_cfft_radix4_init_f32(&fft_inst, FFT_SIZE, 0, 1);
  arm_cfft_radix4_f32(&fft_inst, samples);
  // Calculate magnitude of complex numbers output by the FFT.
  arm_cmplx_mag_f32(samples, magnitudes, FFT_SIZE);


  // Restart audio sampling.
  samplingBegin();
}

void samplingCallback() {
  // Read from the ADC and store the sample data
  samples[sampleCounter] = (float32_t)analogRead(AUDIO_INPUT_PIN);
  // Complex FFT functions require a coefficient for the imaginary part of the input.
  // Since we only have real data, set this coefficient to zero.
  samples[sampleCounter + 1] = 0.0;
  // Update sample buffer position and stop after the buffer is filled
  sampleCounter += 2;
  if (sampleCounter >= FFT_SIZE * 2) {
    samplingTimer.end();
  }
}

void samplingBegin() {
  // Reset sample buffer position and start callback at necessary rate.
  sampleCounter = 0;
  samplingTimer.begin(samplingCallback, 1000000 / SAMPLE_RATE_HZ);
}

boolean samplingIsDone() {
  return sampleCounter >= FFT_SIZE * 2;
}




void noise() {
  uint8_t  x, y;

  while (1) {

    for (x = 0; x < 256; x++) {
      for (y = 0; y < 64; y++) {
        display.drawPixel(x, y, random(15));
      }
      display.display();
      delay(10);
      // display.clearDisplay();
    }
  }
}


