#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform sampler2D textu;
uniform vec2 mirror;
uniform vec2 iResolution;
uniform sampler2D endpic;
uniform float showEndPic;

void main() {
	if (showEndPic < 0.5) {
	    fragColor = texture(textu, UV);
	} else {
		vec2 ic = 0.5+0.5*((-1.0+2.0*vec2(UV.x, 1.-UV.y))/0.75);
		if(ic.x < 1.0 && ic.x > 0.0 && ic.y > 0.0 && ic.y < 1.0){
			fragColor = texture(endpic, clamp(0.5+0.5*((-1.0+2.0*vec2(UV.x, 1.-UV.y))/0.75), 0.0, 1.0) );
	    }else {
			fragColor = vec4(0);
	    }
	}
	fragColor.a = 1.0;
}
