#version 330 core

in vec2 UV;
out vec4 color;

uniform sampler2D textuA;
uniform sampler2D textuB;
uniform float w;

float intensity(vec3 col) {
	return dot(vec3(0.2989, 0.5870, 0.1140), col);
}

void main() {
	color = (intensity(texture(textuA, UV).xyz) < w ? 0.0 : 1.0) * texture(textuB, UV);
}
