#version 330 core

// inputz
in vec2 UV;

// outputz
out vec4 color;

uniform vec2 iResolution;
uniform sampler2D textu;
uniform float iGlobalTime;
#define iTime iGlobalTime
uniform float doGrain;

float letterbox() {
	float w = 16./9.;
	float h = 1.0;

	float y = w / 2.39;
	float b = (h - y) / 2.0;

	return 1.0 - float((UV.y < b) || (UV.y > 1.0 - b));
}

#ifndef FXAA_REDUCE_MIN
    #define FXAA_REDUCE_MIN   (1.0/ 128.0)
#endif
#ifndef FXAA_REDUCE_MUL
    #define FXAA_REDUCE_MUL   (1.0 / 8.0)
#endif
#ifndef FXAA_SPAN_MAX
    #define FXAA_SPAN_MAX     8.0
#endif

//optimized version for mobile, where dependent 
//texture reads can be a bottleneck
vec4 fxaa(sampler2D tex, vec2 fragCoord, vec2 resolution,
            vec2 v_rgbNW, vec2 v_rgbNE, 
            vec2 v_rgbSW, vec2 v_rgbSE, 
            vec2 v_rgbM) {
    vec4 color;
    mediump vec2 inverseVP = vec2(1.0 / resolution.x, 1.0 / resolution.y);
    vec3 rgbNW = texture(tex, v_rgbNW).xyz;
    vec3 rgbNE = texture(tex, v_rgbNE).xyz;
    vec3 rgbSW = texture(tex, v_rgbSW).xyz;
    vec3 rgbSE = texture(tex, v_rgbSE).xyz;
    vec4 texColor = texture(tex, v_rgbM);
    vec3 rgbM  = texColor.xyz;
    vec3 luma = vec3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
    
    mediump vec2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
    
    float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *
                          (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);
    
    float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(vec2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),
              max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
              dir * rcpDirMin)) * inverseVP;
    
    vec3 rgbA = 0.5 * (
        texture(tex, fragCoord * inverseVP + dir * (1.0 / 3.0 - 0.5)).xyz +
        texture(tex, fragCoord * inverseVP + dir * (2.0 / 3.0 - 0.5)).xyz);
    vec3 rgbB = rgbA * 0.5 + 0.25 * (
        texture(tex, fragCoord * inverseVP + dir * -0.5).xyz +
        texture(tex, fragCoord * inverseVP + dir * 0.5).xyz);

    float lumaB = dot(rgbB, luma);
    if ((lumaB < lumaMin) || (lumaB > lumaMax))
        color = vec4(rgbA, texColor.a);
    else
        color = vec4(rgbB, texColor.a);
    return color;
}

float time;
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float hash12(vec2 p){
    vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 9.0);
    return fract((p3.x + p3.y) * p3.z);
}

float noise(vec2 x){
    vec2 f = fract(x)*fract(x)*(3.0-2.0*fract(x));
    return mix(mix(hash12(floor(x)),hash12(floor(x)+vec2(1,0)),f.x),mix(hash12(floor(x)+vec2(0,1)),hash12(floor(x)+vec2(1)),f.x),f.y);
}

float grain(vec2 fragCoord, float strength)
{
    //if(mod(float(iFrame),2.0) < 1.0) discard;
    vec2 uv = fragCoord.xy;
    const float f = 0.75;
    
    vec2 s = iResolution.xy*vec2(hash12(mod(iTime,5.1)*iResolution.xx*f),hash12(mod(iTime,4.9)*iResolution.yy*f));
    float b = noise(s+uv*f);
    const float c = 0.5;
    
    float v1 = b-noise(s+vec2(1,0)/f+uv*f)+c;
    float v2 = b-noise(s+vec2(0,1)/f+uv*f)+c;
    float v3 = b-noise(s+vec2(-1,0)/f+uv*f)+c;
    float v4 = b-noise(s+vec2(0,-1)/f+uv*f)+c;
    
    #define HQ
    #ifdef HQ
        float v5 = b-noise(s+vec2(1)/f+uv*f)+c;
        float v6 = b-noise(s+vec2(-1)/f+uv*f)+c;
        float v7 = b-noise(s+vec2(1,-1)/f+uv*f)+c;
        float v8 = b-noise(s+vec2(-1,1)/f+uv*f)+c;
    #endif
    
    // average
    #ifdef HQ
      float val = (v1+v2+v3+v4+v5+v6+v7+v8)/8.0;
    #else
      float val = (v1+v2+v3+v4)/4.0;
    #endif
    
    return mix(1.0, 0.5+val, strength);
}

// linear white point
const float W = 3.0;
const float T2 = 1.5; // old: 0.75

float filmic_reinhard_curve (float x) {
    float q = (T2*T2 + 1.0)*x*x;    
  return q / (q + x + T2*T2);
}

vec3 filmic_reinhard(vec3 x) {
    float w = filmic_reinhard_curve(W);
    return vec3(
        filmic_reinhard_curve(x.r),
        filmic_reinhard_curve(x.g),
        filmic_reinhard_curve(x.b)) / w;
}

uniform int N; // = 6;

vec2 co(vec2 uv){
  return 0.5-uv*0.5;
}

vec3 ca(sampler2D t, vec2 UV, vec4 sampl){
    time=iGlobalTime;
  vec2 uv = 1.0 - 2.0 * UV;
  vec3 c = vec3(0);
  float rf = 1.0;
  float gf = 1.0;
    float bf = 1.0;
  float f = 1.0/float(N);
  for(int i = 0; i < N; ++i){
    c.r += f*texture(t, co(uv*rf) ).r;
    c.g += f*texture(t, co(uv*gf) ).g;
    c.b += f*texture(t, co(uv*bf) ).b;
    rf *= 0.9975;
    gf *= 0.9982;
        bf /= 0.9992;
    //c = clamp(c,0.0, .0);
  }
  return c;
}

void main() {
//    color = texture(textu, vec2(UV.x, 1.0-UV.y)) * letterbox();
  vec2 tex = vec2(1.0) / iResolution;
    color = fxaa(textu,
                 UV * iResolution,
                 iResolution,
                 UV + vec2(-tex.x, tex.y),
                 UV + tex,
                 UV - vec2(tex.x, tex.y),
                 UV + vec2(tex.x, -tex.y),
                 UV
      ) * letterbox(); // TODO: own pass

    const float brightness = 2.25;
    
    vec2 pp = UV;
    vec2 r = iResolution.xy;
    vec2 p = 1.-2.*UV;
    p.y *= r.y/r.x;
   
    // a little chromatic aberration
    vec4 sampl = texture(textu, pp);
    color = vec4(ca(textu, pp, sampl).rgb, 1.0);
    //vec3 color = sample.rgb;
    
    // final output
    if (doGrain > 0.5) {
        color.xyz *= grain(UV * iResolution, 0.25);
    }
    
    color = vec4( clamp(color.xyz, 0.0, 1.0) * letterbox(), 1.0 );
}
