#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; //const vec2 iMouse = vec2(0.5);

// outputz
out vec4 fragColor;

#define iTime iGlobalTime

const int MODE = 1;
const float PI = 3.141;

/////// SPIRAL CFG
const float N = 40.0;
const float f = 1.2;
const float aa = 1. * f / N;
const float ab = 1.3 * aa;
const float b = 1.0;

/////// Other thing CFG
const float No = 8.0;

// circle thing
const float r = 1.0;


void main()
{
    float phase = iGlobalTime;
    vec2 uv = UV;
    vec2 ray = uv - 0.5;
    if (MODE == 0) {
        phase *= 2.0 * PI;
        float t = mod(atan(ray.y, ray.x) + PI + phase, 2.0*PI);
        fragColor = vec4(vec3(0.0), 1.0);
        for (float m = 0.0; m <= 20.0; m+=1.0) {
            if (length(ray) > aa * t && length(ray) < ab * t) {
                fragColor = vec4(1.0);
                return;
            }
            t += 2.0 * PI;
        }
        return;
    } else if (MODE == 1) {
        float t = float(mod(atan(ray.y, ray.x) + PI + phase, 2.0*PI / No) < 0.5);

        float tt = mod(atan(ray.y, ray.x) + PI + phase, 2.0*PI / No);

        float tc = smoothstep(0.225, 0.75 * PI / No, abs(tt - PI / No));
        fragColor = vec4(tc);
        return;
    } else if (MODE == 2) {
        // dot(o + s * d, o + s * d) == r
        // dot(o, o) + 2 * s * dot(d, o) + s^2 * dot(d, d) + dot(d, d) == r
        // 
        
    }
    
    fragColor = vec4(vec3(0.0), 1.0);
}
