#version 330 core

in vec2 UV;
uniform sampler2D iChannel0;
uniform vec2 iResolution;

out vec4 fragColor;

float intensity(in vec4 color){
    return dot(vec3(0.2989, 0.5870, 0.1140), color.xyz);
}

float sobel(vec2 o, vec2 d){
    float dada[9] = float[9](
        intensity(texture(iChannel0, o + vec2(-d.x,  d.y))),
        intensity(texture(iChannel0, o + vec2(-d.x,  0.0))),
        intensity(texture(iChannel0, o + vec2(-d.x, -d.y))),

        intensity(texture(iChannel0, o + vec2( 0.0,  d.y))),
        intensity(texture(iChannel0, o + vec2( 0.0,  0.0))),
        intensity(texture(iChannel0, o + vec2( 0.0, -d.y))),

        intensity(texture(iChannel0, o + vec2( d.x,  d.y))),
        intensity(texture(iChannel0, o + vec2( d.x,  0.0))),
        intensity(texture(iChannel0, o + vec2( d.x, -d.y)))
    );
 
    vec2 conv = vec2(
        dada[2] + 2.0*dada[1] + dada[6] - dada[8] - 2.0*dada[7] - dada[6],
       -dada[2] - 2.0*dada[1] - dada[8] + dada[2] + 2.0 * dada[5] + dada[6]
    );
    return length(conv);
 }

void main(){
  vec2 uv = UV; // fragCoord.xy / iResolution.xy;
  fragColor.xyz = vec3(sobel(uv, 1.0 / iResolution.xy));
  fragColor.a = 1.0;
}