#version 330                                                                        
                                                                                    
layout (location = 0) in vec3 Position;                                             
layout (location = 1) in vec2 TexCoord;                                             
layout (location = 2) in vec3 Normal;                                               
layout (location = 3) in ivec4 BoneIDs;
layout (location = 4) in vec4 Weights;

out vec3 Normal0;                                                                   
out vec3 WorldPos0;                                                                 

const int MAX_BONES = 100;

uniform mat4 gWVP;
uniform mat4 gWorld;
uniform mat4 gBones[MAX_BONES];

uniform sampler2D spectrum;
uniform float spectrumCoef;
uniform float spectrumAmpl;
uniform vec3 specdir;

void main()
{       
    mat4 BoneTransform = gBones[BoneIDs[0]] * Weights[0];
    BoneTransform     += gBones[BoneIDs[1]] * Weights[1];
    BoneTransform     += gBones[BoneIDs[2]] * Weights[2];
    BoneTransform     += gBones[BoneIDs[3]] * Weights[3];


    vec4 NormalL = BoneTransform * vec4(Normal, 0.0);
    vec4 PosL    = BoneTransform * vec4(Position + max(dot(NormalL.xyz, specdir), 0.0) * spectrumAmpl * texture(spectrum, vec2(spectrumCoef, 0.0)).r * normalize(NormalL.xyz), 1.0);
    gl_Position  = gWVP * PosL;
    Normal0      = (gWorld * NormalL).xyz;
    WorldPos0    = (gWorld * PosL).xyz;                                
}
