#version 330

in vec3 Normal0;
in vec3 WorldPos0;
layout(location = 0) out vec4 colors;
layout(location = 1) out vec4 normals;
uniform vec3 cutPlaneA;
uniform vec3 cutPlaneAn;
uniform int useCutA;
uniform vec3 cutPlaneB;
uniform vec3 cutPlaneBn;
uniform int useCutB;

void main() {
    if (useCutA > 0 && dot(WorldPos0 - cutPlaneA, cutPlaneAn) < 0.0 || useCutB > 0 && dot(WorldPos0 - cutPlaneB, cutPlaneBn) < 0.0) {
        discard;
    }
    colors = vec4(1.0, 0.0, 1.0, 1.0);
    normals = vec4(Normal0, 1.0);
}
