#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D positionbuffer;
uniform sampler2D dbuffer;
uniform mat4 projection;
uniform mat4 V;
uniform float seed;
uniform vec3 lightpos;

vec3 getPos(vec2 uv) {
    return texture(positionbuffer, uv).xyz;
  float z = 2.0 * texture(dbuffer, uv).x - 1.0;
  vec4 clipSpace = vec4(2.0*UV-1.0, z, 1.0);
  vec4 homogLoc = inverse(projection) * clipSpace;
  return homogLoc.xyz / homogLoc.w;
}

float hash1( uint n ) 
{
    // integer hash copied from Hugo Elias
    n = (n << 13U) ^ n;
    n = n * (n * n * 15731U + 789221U) + 1376312589U;
    return 1.0 - float( n & uvec3(0x7fffffffU))/float(0x7fffffff);
}

float distance(float depth) {
    vec4 screenPos = vec4(UV.x, UV.y, depth, 1.0) * 2.0 - 1.0;
    vec4 viewPosition = inverse(projection) * screenPos;
    return -(viewPosition.z / viewPosition.w);
}

float shadow(float k) {
    if (texture(dbuffer, UV).x == 1.0) {
        return 1.0;
    }

    // Compute deltaUV from pt to (point) light source
    // Make sure that the origin and lightpos are in the same space (in this case: view space) 
    vec3 origin = getPos(UV);
    vec4 vlightpos = V*vec4(lightpos, 1.0);
    vec4 dpos = projection * vec4(vlightpos.xyz - origin, 1.0);
    vec2 duv = dpos.xy; // !

    // High quality ~256, acceptable 128, shit less
    const float ITERMAX = 256.0;
    float res = 1.0;
    float t = 0.5;
    const float malpha = 0.0;
    for (float i = 1.0; i <= ITERMAX; i+=1.) {
         float jitter = 0.2*(hash1(uint(240.0*i*UV.y*UV.y + 352.*UV.x + 4324.0*UV.y + 433.0 *seed))*.5 - .5);
         float c = (i + jitter) / ITERMAX;
         vec2 curv = (UV + c * duv);
          vec3 curp = origin + c * (vlightpos.xyz - origin);

          if (curv.x > 1.0 || curv.y > 1.0 || curv.x < 0.0 || curv.y < 0.0) {
            break;
          } else if (texture(dbuffer, curv).x == 1.0) {
          	continue;
          } else if (length(curp) > length(getPos(curv))) {
            return 0.0;
          }
          float h = length(getPos(curv) - curp);
          res = min(res, k * h / t);
          t += h;
    }

    return 1.0;
}

void main() {
	color.xyzw = vec4(shadow(1.0));
}
