#version 330 core

in vec2 UV;
uniform vec2 iResolution;
#define iTime iGlobalTime
uniform float iGlobalTime;

out vec4 fragColor;

#define ITERATIONS 4


// *** Change these to suit your range of random numbers..

// *** Use this for integer stepped ranges, ie Value-Noise/Perlin noise functions.
#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)

// For smaller input rangers like audio tick or 0-1 UVs use these...
//#define HASHSCALE1 443.8975
//#define HASHSCALE3 vec3(443.897, 441.423, 437.195)
//#define HASHSCALE4 vec3(443.897, 441.423, 437.195, 444.129)



//----------------------------------------------------------------------------------------
//  1 out, 1 in...
float hash11(float p)
{
    vec3 p3  = fract(vec3(p) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

#define MAX_BOUNCES 2
#define SAMPLES 25
float seed;
float gamma = 2.2;
vec3 spos;

float stime;

struct Material
{
    vec3 c;     // diffuse color
    float f0;   // specular color (monochrome)
    float sp;
};

#define PI 3.14159265358979
float hash(float p)
{
    vec3 p3  = fract(vec3(p) * 443.8975);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

struct Ray
{
    vec3 o;     // origin
    vec3 d;     // direction
};

struct Hit
{
    float t;    // solution to p=o+t*d
    vec3 n;     // normal
    Material m; // material
};
const Hit noHit = Hit(1e10, vec3(0.), Material(vec3(-1.), -1., -1.));

struct Plane
{
    float d;    // solution to dot(n,p)+d=0
    vec3 n;     // normal
    Material m; // material
};
    
struct Sphere
{
    float r;    // radius
    vec3 p;     // center position
    Material m; // material
};

Hit intersectPlane(Plane p, Ray r)
{
    float dotnd = dot(p.n, r.d);
    if (dotnd > 0.) return noHit;

    float t = -(dot(r.o, p.n) + p.d) / dotnd;
    return Hit(t, p.n, p.m);
}

Hit intersectSphere(Sphere s, Ray r)
{
    vec3 op = s.p - r.o;
    float b = dot(op, r.d);
    float det = b * b - dot(op, op) + s.r * s.r;
    if (det < 0.) return noHit;

    det = sqrt(det);
    float t = b - det;
    if (t < 0.) t = b + det;
    if (t < 0.) return noHit;

    return Hit(t, (r.o + t*r.d - s.p) / s.r, s.m);
}

float ff;
Hit intersectScene(Ray r)
{

    Plane pb  = Plane(6.0, vec3(0,1.0,0),  Material(vec3(0),     ff, 0.0));
    Plane pl  = Plane(11.0, vec3(1,0,0),  Material(vec3(0),     ff, 0.0));
    Plane pf  = Plane(5.0, vec3(0,0,1),  Material(vec3(0),     ff, 0.0));
    Sphere s1 = Sphere(2., vec3(4,-3,-0), Material(vec3(0), 0.01, 1.25));
    Sphere s2 = Sphere(2., vec3(-3,-3,-3), Material(vec3(0), 0.1, 0.5));
    Sphere s3 = Sphere(2., vec3(1,-3,-6), Material(vec3(1,0,0), 1.0, 0.0));
    //Plane pu  = Plane(5.0, vec3(0,-1,0), Material(vec3(0),  ff, rr));
    //Plane pr  = Plane(5.0, vec3(-1,0,0), Material(vec3(1),     ff, rr));
    //Plane pt  = Plane(5.0, vec3(0,0,-1), Material(vec3(0),     ff, rr));
    
    Hit hit = noHit;//Hit(1e5, vec3(0.), Material(vec3(-1.), -1., -1.));
    Hit hitb = intersectPlane(pb, r);  if (hitb.m.f0 >= 0. && hitb.t < hit.t) { hit = hitb; }
    //vec3 pos = r.o + hitb.t * r.d;
    //hit.t += texture(iChannel0, pos.xz*5.0).r;
    //Hit hitl = intersectPlane(pl, r);  if (hitl.m.f0 >= 0. && hitl.t < hit.t) { hit = hitl; }
    //Hit hitf = intersectPlane(pf, r);  if (hitf.m.f0 >= 0. && hitf.t < hit.t) { hit = hitf; }
    Hit hits  = intersectSphere(s1, r);  if (hits.m.f0 >= 0. && hits.t < hit.t) { hit = hits; }
    Hit hits2 = intersectSphere(s2, r);  if (hits2.m.f0 >= 0. && hits2.t < hit.t) { hit = hits2; }
    Hit hits3 = intersectSphere(s3, r);  if (hits3.m.f0 >= 0. && hits3.t < hit.t) { hit = hits3; }
    /*if (hits.m.f0 >= 0. && hits.t < hit.t) {
        hit = hits;
        float vc = pow(min(1.0,mod( stime+(hit.t*r.d+r.o).y, 2.0 )), 99.);
        hit.m.c.r += 3.0*vc;
        hit.m.c.b -= 2.0*vc;
        hit.m.c *= 0.75;
    }*/
    //Hit hitu = intersectPlane(pu, r);  if (hitu.m.f0 >= 0. && hitu.t < hit.t) { hit = hitu; }
    //Hit hitr = intersectPlane(pr, r);  if (hitr.m.f0 >= 0. && hitr.t < hit.t) { hit = hitr; }
    //Hit hitt = intersectPlane(pt, r);  if (hitt.m.f0 >= 0. && hitt.t < hit.t) { hit = hitt; }
    
    return hit;
}

float pow5(float x) { return x * x * x * x * x; }
float fresnel(vec3 h, vec3 v, float f0)
{
    return pow5(1. - clamp(dot(h, v), 0., 1.)) * (1. - f0) + f0;
}

vec3 accountPointLight(vec3 p, vec3 n, vec3 l)
{
    vec3 v = normalize(l-p);
    float e = max(0.0, dot(n, v));
    return 10000.0*vec3(e)/max(0.0, pow(distance(l, p), 2.0));
}

float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * 0.1031);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

vec2 hash2(float p)
{
    vec3 p3 = fract(vec3(p) * vec3(443.897, 441.423, 437.195));
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}

vec3 cosw(const vec3 n, float seed)
{
    vec2 rv2 = hash2(seed);
    vec3  uu = normalize( cross( n, vec3(0.0,1.0,1.0) ) );
    vec3  vv = normalize( cross( uu, n ) ); 
    float ra = sqrt(rv2.y);
    float rx = ra*cos(6.2831*rv2.x); 
    float ry = ra*sin(6.2831*rv2.x);
    float rz = sqrt( 1.0-rv2.y );
    vec3  rr = vec3( rx*uu + ry*vv + rz*n );
    return normalize( rr );
}

vec3 getLight(vec3 p)
{
    /*
    if(p.x > 9.0 || p.x < -9.0) return vec3(0);
    float qt = float(int(stime*8.0));
    vec3 ap = vec3(int(p.x*0.7) & int(0.4*p.y-qt*91.0),
                   p.y*float(int(qt)&int(100.0-p.x*10.0)),
                   
                   int(1.3*p.z+qt*5.0) & int( 0.1*float(int(p.y)&int(mod(stime,9.0)))*p.y));
    return vec3(pow(min(1.0, 0.1+mod(distance(vec3(0), ap), 1.0)),9999.0));///pow(distance(vec3(0),p),1.0);
*/
    if(p.x > 9.0 || p.x < -9.0) return vec3(0);
    
    float qt = float(int(stime*8.0));
    p *= vec3(1./9.,50.0,0.0);
    p = mod(p.xyz, 9.0);
    vec3 ap = vec3(int(p.z-qt*5.0), 
                   int(0.001+p.y+qt*1.0)|int(p.z*120.0),
                    int(p.x*20.0)&int(p.z*0.1+qt));
    //ap += 0.0001*dot(p, ap);
    return 10.0*min(vec3(0.1), vec3(pow(min(1.0, 0.1+mod(distance(vec3(0), ap), 1.0)),9999.0)));
}

vec3 radiance(Ray r)
{
    vec3 accum = vec3(0);
    for (int i = 0; i <= MAX_BOUNCES; i++)
    {
        Hit hit = intersectScene(r);

        if(hit != noHit)
        {
            vec3 pos = r.o + hit.t * r.d;
            //ff = 0.05+0.45*pow( min(1.0, 0.5+0.5*sin(pos.x)+0.5+0.5*cos(pos.z)), 999.0);
            
            ff = 0.02+0.58*pow( min(1.0, 1.25*hash12(0.00077*pos.xz)*1.25*hash12(0.01*pos.xz)), 4.0);
            
            float f = fresnel(hit.n, -r.d, hit.m.f0)+hit.m.sp;
            // Get light source (color * light intensity * pattern)
            accum += hit.m.c * vec3(30);//*getLight(r.o + hit.t * r.d);

            vec3 cd = cosw(hit.n, seed);
            vec3 dn = normalize(mix(hit.n, cd, hit.m.f0));
            vec3 d = (f) < seed ? reflect(r.d, cd) : reflect(r.d, dn);
            r = Ray(r.o + hit.t * r.d + 0.002 * d, d);
        } else {
            return vec3(10);
        }
    }
    return accum;
}

vec3 Uncharted2ToneMapping(vec3 color)
{
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    float W = 11.2;
    float exposure = 0.015;
    color *= exposure;
    color = ((color * (A * color + C * B) + D * E) / (color * (A * color + B) + D * F)) - E / F;
    float white = ((W * (A * W + C * B) + D * E) / (W * (A * W + B) + D * F)) - E / F;
    color /= white;
    color = pow(color, vec3(1. / gamma));
    return color;
}

mat3 lookat( in vec3 fw, in vec3 up )
{
    fw = normalize(fw);
    vec3 rt = normalize( cross(fw, normalize(up)) );
    return mat3( rt, cross(rt, fw), fw );
}

void main()
{
    vec2 uv = 2. * UV - 1.;
    if(uv.y > 0.75 || uv.y < -0.75) return;
    
    

    vec3 color = vec3(0.);
    float shutter = 0.1;
    
    vec3 p0 = vec3(10.0*cos(iGlobalTime*0.31), -.4, 24.);
    float rtime = mod(iGlobalTime, 12.3);
    fragColor = vec4(vec3(0.0), 1.0);
    for (int i = 0; i < SAMPLES; ++i)
    {
        seed = hash12(123.4*uv+rtime+float(i));
        stime = (iGlobalTime + shutter*(1.0/24.0)*seed)*2.0;
        vec3 p = p0;
        vec3 offset = vec3(3.6*hash2(dot(uv.x,uv.y)+rtime+float(i)) / iResolution.y, 0.);
        vec3 d = normalize(vec3(iResolution.x/iResolution.y * uv.x, uv.y, -5.) + offset);
        
        //d *= lookat(p0+10.0*vec3(sin(stime*0.21),-1.0+cos(stime*0.35),0), vec3(0,1,0));
        d *= lookat(p0+10.0*vec3(0, -0.4-0.2*sin(stime*0.23), 1), vec3(0,1,0));
        
        //d = cross(d, normalize(vec3(0,-3,-2)));
        Ray r = Ray(p, d);
        color += radiance(r);
    }
    color *= exp(-.5*dot(uv,uv))/float(SAMPLES);
    fragColor.xyz=Uncharted2ToneMapping(pow(color, vec3(1.9)));
    fragColor.xyz = vec3(length(fragColor.xyz) > 0.75);
    //fragColor.rgb = smoothstep(0.2, 0.95, fragColor.rgb);
}

