#version 330 core
// Copy-pasted from various sources in winter 2016-2017
// Special props to http://graphicrants.blogspot.fi/2013/08/specular-brdf-reference.html
// and shaders on the internet (probably on shadertoy and ferris' stream)
// (i think it was from a shadertoy snippet - can't find it anymoar)
in vec2 UV;
out vec4 color;
uniform sampler2D colorbuffer;
uniform sampler2D positionbuffer;
uniform sampler2D normalbuffer;
uniform sampler2D aobuffer;
uniform sampler2D dbuffer;
uniform sampler2D shadowmap;
uniform mat4 projection;
uniform mat4 V;
uniform float seed;

uniform float fresnelpow;
uniform float fresnelint;

const float pi = 3.14159265;
const float roughness = 0.7;
const float metallicaness = 1.0; // budumtshis
uniform vec3 lightpos;

float G1V(float NdotV, float k) {
	return 1.0/(NdotV*(1.0-k)+k);
}

float SpecGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0 ) {
	vec3 H = normalize(V + L);
	float NdotL = min(1.0, max(0.0, dot(N,L)));
	float NdotV = min(1.0, max(0.0, dot(N,V)));
	float NdotH = min(1.0, max(0.0, dot(N,H)));
	float LdotH = min(1.0, max(0.0, dot(L,H)));

	float denom = NdotH * NdotH *(pow(roughness, 4.0)-1.0) + 1.0;
	float D = pow(roughness, 4.0)/(pi * denom * denom);

    // Schlick at http://graphicrants.blogspot.fi/2013/08/specular-brdf-reference.html
	float LdotH5 = 1.0-LdotH;
    LdotH5 = LdotH5*LdotH5*LdotH5*LdotH5*LdotH5;
	float F = F0 + (1.0-F0)*(LdotH5);
	float k = roughness*roughness/2.0;
	float specular = NdotL * D * F * G1V(NdotL,k)*G1V(NdotV,k);
    
	return specular;
}

vec3 colcontr(vec3 v, vec3 normal, vec3 lDir, vec3 lColor, float roughness, float metallicness) {
    float Diffuse = max(0., dot ( normal, lDir ));
    float Spec = SpecGGX(normal,v,lDir,roughness,metallicness);
     
    // Fresnel
    float NdotV = clamp(dot(normal,v),0.0,1.0);
	NdotV = pow(1.0-NdotV,5.0);    
	float Fresnel = metallicness + (1.0-metallicness)*(NdotV);

    // Tint lights
    vec3 SpecColor = Spec * lColor;
    vec3 DiffColor = Diffuse * lColor * (1.0 - Fresnel);
    
    // Ambient light / "reflections"
    float ambient = 0.8; 
    vec3 ColorAmbient = vec3(ambient);
    vec3 reflection = vec3(0.001);
    
    ColorAmbient = reflection * ambient;    
    vec3 lightSum = max(((DiffColor + SpecColor)*(1.0-ambient) ),vec3(0.0,0.0,0.0));
    //return ColorAmbient;
       
    return ( lightSum + ColorAmbient*texture(aobuffer, UV).x + ( Fresnel * reflection ) );
}

void main() {
	color.xyz = .5*(texture(normalbuffer, UV).xyz + 1.0);
	vec3 p = texture(positionbuffer, UV).xyz;
	vec3 n = normalize(texture(normalbuffer, UV).xyz);
    vec4 tlightpos = V*vec4(lightpos, 1.0);
    vec3 vlightpos = tlightpos.xyz;
	vec3 lDir = normalize(p - vlightpos);
	vec3 lColor = 8.0*vec3(0.68,0.42,0.61).grb;
	color.xyz = texture(shadowmap, UV).xyz * colcontr(-normalize(p), n, -lDir, lColor, roughness, metallicaness);
	
	float fresnel = pow( 1.0+dot(n, normalize(p)), fresnelpow );
	if(length(p) > 0.0) color.xyz += fresnelint*fresnel;
	
	color.a = 0.5;
}
