#version 330 core

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal;

out vec2 UV;
out vec4 vpos;
out vec3 normal;

uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;

void main(){
	gl_Position =  MVP * vec4(vertexPosition.xyz,1.);
	UV = vertexUV;
	vec4 viewpos = V * vec4(vertexPosition.xyz,1.);
	vpos = viewpos;
	vec4 t = inverse(transpose(V * M)) * vec4(vertexNormal, 0.0);
	normal = normalize(t.xyz);
}

