#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform sampler2D textuA;
uniform sampler2D textuB;
uniform float w;
uniform float iGlobalTime;
uniform vec2 iResolution;

#define AA

float hash(uint n) 
{
	n = (n << 13U) ^ n;
    n = n * (n * n * 15731U + 789221U) + 1376312589U;
    return uintBitsToFloat( (n>>9U) | 0x3f800000U ) - 1.0;
}

vec3 julia(vec2 uv, vec2 anim)
{
    vec2 c = anim-mix(vec2(1.2,0.3), vec2(0.7451,0.1102), anim);
    vec2 Z = vec2(uv);
    float B = 4.0;
    
    int i = 0;
    const int iter = 13;
    vec2 zmax = vec2(0);
    for(i; i < iter; i++)
    {
        Z = vec2(Z.x*Z.x - Z.y*Z.y, 2.0*Z.x*Z.y ) + c;
        zmax = tan(2.0*max(zmax, Z));
        if(length(Z) > (B*B*1.0)) break;
    }
    return clamp(vec3( pow(min(zmax.x,zmax.y), 30.) ), 0.0, 1.0);
}

void main()
{
    vec2 uv = (-iResolution.xy)/iResolution.y + 2.0*vec2(UV.x * iResolution.x / iResolution.y, UV.y);
    
    float zoom = 0.25;//1.0/(1.0+exp(mod(0.0, 99.0)));
    uv *= zoom;
    uv += vec2(0.16, -0.44);
    
    vec2 anim = vec2(0);
    float time = 2.3+iGlobalTime*0.005;
    float iFrame = 60. * iGlobalTime;
#ifdef AA
    vec2 aa = 2.0/iResolution.xy;
    const uint S = 32U;
    
    anim = vec2(0.5+0.5*sin((time)*0.43), 0.5+0.5*cos((time)*0.57));
    
    uvec2 p = uvec2(UV * iResolution.xy);
    vec4 t = vec4(0.0);
    for(uint i = 0U; i < S; i++)
    {
        
        float hx = hash(i + p.x + 1920U*p.y + (1920U*1080U)*uint(iFrame) );
        float hy = hash(i + p.y + 1080U*p.x + (1920U*1080U)*uint(iFrame) );
        t += vec4(vec3(julia(uv + zoom*aa*vec2(hx,hy), anim)), 1.0);
    }
    t /= float(S);
#endif
	float bl = smoothstep(-0.1, 1.2, t.x);
    fragColor = bl * texture(textuA, UV) + (1.0 - bl) * texture(textuB, UV);
    fragColor = texture((bl < w) ? textuA : textuB, UV);
}
