#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; //const vec2 iMouse = vec2(0.5);

// outputz
out vec4 fragColor;

#define iTime iGlobalTime

float hash12(vec2 p){
    vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 9.0);
    return fract((p3.x + p3.y) * p3.z);
}

float noise(vec2 x){
    vec2 f = fract(x)*fract(x)*(3.0-2.0*fract(x));
    return mix(mix(hash12(floor(x)),hash12(floor(x)+vec2(1,0)),f.x),mix(hash12(floor(x)+vec2(0,1)),hash12(floor(x)+vec2(1)),f.x),f.y);
}

void main()
{
    vec2 uv = -1.0+2.0*UV;
    uv.x *= iResolution.x/iResolution.y;
    
    float t = iTime*0.4;
    float c = 0.0;
    
    const int l = 30;
    for(int i = 0; i < l; i++)
    {
        uv *= pow(1.04,c);
        float c1 = noise(10.0*vec2(-1.0*noise(vec2(uv+vec2(t,0))), noise(vec2(uv-vec2(0,t))) ));
        float c2 = noise(30.0*vec2(noise(vec2(uv-vec2(t,0))), -1.0*noise(vec2(uv+vec2(0,t))) ));
        c = noise(vec2(c1,0.3*c2));
    }
    //fragColor.rgb = 1.0-mix(vec3(0,.02,.06),vec3(1.4,1.6,2),0.06/(c+0.1)).bgr*smoothstep(1.6, 1.4, length(uv));
    fragColor.rgb = mix(vec3(0,.02,.06),vec3(1.4,1.6,2), c)*smoothstep(1.5, 1.3, length(uv));
    fragColor.rgb = mix(fragColor.rgb, vec3(dot(fragColor.rgb, vec3(0.299, 0.587, 0.114) )), 1.0);
    fragColor.a = 1.0;
}
