#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;
uniform sampler2D iChannel0;

void main()
{
  vec2 uv = UV;
    vec3 col;
    
    /*** Sobel kernels ***/
    // Note: GLSL's mat3 is COLUMN-major ->  mat3[col][row]
    mat3 sobelX = mat3(-1.0, -2.0, -1.0,
                       0.0,  0.0, 0.0,
                       1.0,  2.0,  1.0);
    mat3 sobelY = mat3(-1.0,  0.0,  1.0,
                       -2.0,  0.0, 2.0,
                       -1.0,  0.0,  1.0);  
    
    float sumX = 0.0; // x-axis change
    float sumY = 0.0; // y-axis change
    
    for(int i = -1; i <= 1; i++)
    {
        for(int j = -1; j <= 1; j++)
        {
            // texture coordinates should be between 0.0 and 1.0
            float x = (floor(UV.x*iResolution.x) + float(i))/iResolution.x; 
            float y = (floor(UV.y*iResolution.y) + float(j))/iResolution.y;
            
            // Convolve kernels with image
            sumX += length(texture( iChannel0, vec2(x, y) ).www) * float(sobelX[1+i][1+j]);
            sumY += length(texture( iChannel0, vec2(x, y) ).www) * float(sobelY[1+i][1+j]);
        }
    }
    
    float g = abs(sumX) + abs(sumY);
    //g = sqrt((sumX*sumX) + (sumY*sumY));
    
    if(g > 1.0)
        col = vec3(1.0,1.0,1.0);
    else
        col = col * 0.0;
    
  fragColor.xyz = col;
  fragColor.a = 1.0;
}
