#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;
uniform sampler2D iChannel0;
uniform float fbs;

vec3 mod289(vec3 x){
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 mod289(vec4 x){
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x){
     return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(vec4 r){
  return 1.79284291400159 - 0.85373472095314 * r;
}

float simplex(vec3 v){
  const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;
  const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);

  vec3 i  = floor(v + dot(v, C.yyy) );
  vec3 x0 =   v - i + dot(i, C.xxx) ;

  vec3 g = step(x0.yzx, x0.xyz);
  vec3 l = 1.0 - g;
  vec3 i1 = min( g.xyz, l.zxy );
  vec3 i2 = max( g.xyz, l.zxy );

  vec3 x1 = x0 - i1 + C.xxx;
  vec3 x2 = x0 - i2 + C.yyy;
  vec3 x3 = x0 - D.yyy;

  i = mod289(i);
  vec4 p = permute( permute( permute(
             i.z + vec4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0 ))
           + i.x + vec4(0.0, i1.x, i2.x, 1.0 ));

  float n_ = 0.142857142857;
  vec3  ns = n_ * D.wyz - D.xzx;

  vec4 j = p - 49.0 * floor(p * ns.z * ns.z);

  vec4 x_ = floor(j * ns.z);
  vec4 y_ = floor(j - 7.0 * x_ );

  vec4 x = x_ *ns.x + ns.yyyy;
  vec4 y = y_ *ns.x + ns.yyyy;
  vec4 h = 1.0 - abs(x) - abs(y);

  vec4 b0 = vec4( x.xy, y.xy );
  vec4 b1 = vec4( x.zw, y.zw );

  vec4 s0 = floor(b0)*2.0 + 1.0;
  vec4 s1 = floor(b1)*2.0 + 1.0;
  vec4 sh = -step(h, vec4(0.0));

  vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

  vec3 p0 = vec3(a0.xy,h.x);
  vec3 p1 = vec3(a0.zw,h.y);
  vec3 p2 = vec3(a1.xy,h.z);
  vec3 p3 = vec3(a1.zw,h.w);

  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;

  vec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  m = m * m;
  return 42.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1),
                                dot(p2,x2), dot(p3,x3) ) );
  }

float fbm3(vec3 v) {
    float result = simplex(v);
    result += simplex(v * 2.) / 2.;
    result += simplex(v * 4.) / 4.;
    result /= (1. + 1./2. + 1./4.);
    return result;
}

float hash12(vec2 p){
    vec3 p3  = fract(vec3(p.xyx) * 0.1031);
    p3 += dot(p3, p3.yzx + 9.0);
    return fract((p3.x + p3.y) * p3.z);
}

float noise(vec2 x){
    vec2 f = fract(x)*fract(x)*(3.0-2.0*fract(x));
    return mix(mix(hash12(floor(x)),
                   hash12(floor(x)+vec2(1,0)),f.x),
               mix(hash12(floor(x)+vec2(0,1)),
                   hash12(floor(x)+vec2(1)),f.x),f.y);
}

float circle(vec2 uv, vec2 pos, float sz){
    // draw a circle at mouse coordinates
    float s = (3.0+0.0*pow(noise(vec2(iGlobalTime*0.5)),2.0))/sz;
    uv += pos+vec2(1.0/s);
    float val = clamp(1.0-length(s*uv-1.0), 0.0, 1.0);
    val = pow(2.0*val, 4.0);
    return (clamp(val, 0.0, 1.0));
}

vec2 hash21(float p){
    vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);
}

void main(){
    vec2 uv = vec2(UV.x * iResolution.x / iResolution.y, UV.y);
    
    // could be changed to anything (text, picture)
    float mask = circle(uv, -vec2(0.888888, 0.5), 2.0)-circle(uv, -vec2(0.888888, 0.5), 1.25);
    
    fragColor.rgb = mix(0.0, 0.13, fbs)*vec3( pow( abs(simplex( vec3(uv*90.,iTime*7.0) )), 3.0));
    
    fragColor.w = mask;
    fragColor.rgb *= 1.0-pow(fragColor.w, 2.0);
    
    #define SCREENDOOR
    #ifdef SCREENDOOR
    float spacing = 0.5;//iMouse.y/iResolution.y;
    fragColor.rgb *= vec3(1.25)*(-spacing/2.0+mod(floor(UV.x*iResolution.x)*spacing, 2.0));
    fragColor.rgb *= vec3(1.25)*(-spacing/2.0+mod(floor(UV.y*iResolution.y)*spacing, 2.0));
    #endif
    fragColor.a = 1.0;
    
    return;
}
