#version 330 core

// inputz
in vec2 UV;

// outputz
out vec4 color;

uniform vec2 resolution;
uniform sampler2D textu;
uniform vec2 dvec;       // a unit vector
uniform float nsamples;
uniform float sigma;

void main() {
	vec4 otpt = vec4(0.0);
	float wsum = 0.0;
	for (float i = 0.0; i < nsamples; i += 1.0) {
		float x = i - nsamples / 2.0;
		float w = exp(-.5 * x * x / sigma / sigma); // TODO: prolly scale with resolution or sthing
		otpt += w * texture(textu, UV + x * dvec / resolution);
		wsum += w;
	}
	color = otpt / wsum;
}
