#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform float iGlobalTime;
#define iTime iGlobalTime
uniform vec2 iResolution;
uniform sampler2D iChannel0;

vec3 rgbToYCbCr(in vec3 rgb)
{
    float y = dot(rgb, vec3(0.299, 0.587, 0.114));
    float cb = 0.5 + dot(rgb, vec3(-0.168736, -0.331264, 0.5));
    float cr = 0.5 + dot(rgb, vec3(0.5, -0.418688, -0.081312));
    return vec3(y, cb, cr);
}

vec3 yCbCrToRgb(in vec3 ycbcr)
{
    float cb = ycbcr.y - 0.5;
    float cr = ycbcr.z - 0.5;
    float y = ycbcr.x;
    float r = 1.402 * cr;
    float g = -0.344 * cb - 0.714 * cr;
    float b = 1.772 * cb;
    return vec3(r, g, b) + y;
}

void main()
{
    // assuming 8x8 DCT, effectively 4 chroma samples per block
    const float sub_sample = 0.125;
    vec2 uv = UV;
    vec3 c_full = texture(iChannel0, uv).rgb;
    vec3 c_half = texture(iChannel0, round(uv*iResolution.xy*sub_sample)/(iResolution.xy*sub_sample)  ).rgb;
    
    vec3 ycbcr_full = rgbToYCbCr(c_full);
    vec3 ycbcr_half = rgbToYCbCr(c_half);
    float Y  = ycbcr_full.x;
    float Cb = ycbcr_half.y;
    float Cr = ycbcr_half.z;
    fragColor.rgb = yCbCrToRgb(vec3(Y, Cb, Cr));
}
