#version 330 core

// inputz
in vec2 UV;

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform vec2 iResolution;
uniform float iGlobalTime;

// outputz
out vec4 fragColor;

vec3 iMouse = vec3(0.0, 0.0, 0.0);
vec2 offset [9];
float kernel [9];

float hash(vec3 p)  // replace this by something better
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash(p+vec3(0,0,0)), 
                        hash(p+vec3(1,0,0)),f.x),
                   mix( hash(p+vec3(0,1,0)), 
                        hash(p+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash(p+vec3(0,0,1)), 
                        hash(p+vec3(1,0,1)),f.x),
                   mix( hash(p+vec3(0,1,1)), 
                        hash(p+vec3(1,1,1)),f.x),f.y),f.z);
}

void main(void)
{
    vec2 uv = -1.0+2.0*UV;
    
    
    float ang = (atan(uv.y, uv.x)/3.141);
    
    ang = pow(noise(vec3(ang*12.0, ang*12.0, iGlobalTime*1.0)), 9.0)*9000.0;
    vec2 uvd = uv;
    ang = 1.0-mix(1.0, ang, smoothstep(0.6, 0.9, length(vec2(uv.x, uv.y*0.6))));
    
    //fragColor = vec4(ang);
    //return;
    
    uvd *= 0.995-0.001*ang;
    
    uvd = 0.5+0.5*uvd;
        
        
    uv = 0.5+0.5*uv;
    vec2 coord = uv.xy;
    
    vec2 res = iResolution.xy;
    float sc = (3.0+9.0*smoothstep(0.4,0.6, ang))*(iResolution.x/800.0);
    vec2 step = vec2(sc) / res;
	offset[0] = vec2(-step.x, -step.y);
    offset[1] = vec2(0.0, -step.y);
    offset[2] = vec2(step.x, -step.y);
    
    offset[3] = vec2(-step.x, 0.0);
    offset[4] = vec2(0.0, 0.0);
    offset[5] = vec2(step.x, 0.0);
    
    offset[6] = vec2(-step.x, step.y);
    offset[7] = vec2(0.0, step.y);
    offset[8] = vec2(step.x, step.y);
    
    const float cs = -2.0;
    kernel[0] = 0.5*cs+cs*sin(iGlobalTime); kernel[1] = 1.; kernel[2] = 0.5*cs+cs*sin(iGlobalTime*0.9);
    kernel[3] = 1.0; kernel[4] = -9.; kernel[5] = 1.0;
    kernel[6] = 0.5*cs+cs*sin(iGlobalTime*0.8); kernel[7] = 1.; kernel[8] = 0.5*cs+cs*sin(iGlobalTime*0.7);
    
    vec4 sum = vec4(0.0);
    
    for (int i = 0; i < 9; i++) {
        vec4 color = texture(iChannel0, uvd + offset[i]);
        sum += color * kernel[i];
    }
	sum /= (1.0 +2.0*ang)/(800.0/iResolution.x);
    
    vec3 col = clamp(sum , vec4(0.0), vec4(1.0)).rgb;
    
    vec2 uvc = -1.4+2.0*uv;
    float ang2 = mix(1.0, pow(smoothstep(1.0, 0.6, length(vec2(uvc.x, uvc.y*0.6))), 15.0), 0.2);
    col *= ang2;
    
    vec3 ov = texture(iChannel1, uv).rgb;
    
    ov *= ang+ang2;
    
    fragColor = clamp(mix(vec4(ov, sc), 0.95*vec4(col,sc), pow(1.0-length(ov),1.0) ), 0.0, 1.0);
    
    fragColor = mix(vec4(ov, sc), fragColor, 1.0-max(0.0, iMouse.z));
    fragColor.a = 1.0;
}
