#version 330 core

// inputz
in vec2 UV;
uniform sampler2D prevFrame;
uniform sampler2D source;
uniform sampler2D sobel;
uniform float weight;
uniform float sobelWeight;
uniform int fx;
uniform float iGlobalTime;
uniform float curlweight;
uniform vec2 iResolution;

#define itime iGlobalTime

// outputz
out vec4 color;

//////////////////// BLEND (1)
void blend() {
    color = (1.0 - weight) * texture(prevFrame, UV) + weight * texture(source, UV) + sobelWeight * texture(sobel, UV);
}

/////////////////// CURL NOISE (2)

vec2 hash( vec2 p ) {             // rand in [-1,1]
    p = vec2( dot(p,vec2(127.1,311.7)),
                dot(p,vec2(269.5,183.3)) );
    return -1. + 2.*fract(sin(p+20.)*53758.5453123);
}

float noise( in vec2 p ) {
        vec2 i = floor(p), f = fract(p);
        vec2 u = f*f*(3.-2.*f);
        return mix( mix( dot( hash( i + vec2(0.,0.) ), f - vec2(0.,0.) ), 
                                         dot( hash( i + vec2(1.,0.) ), f - vec2(1.,0.) ), u.x),
                                mix( dot( hash( i + vec2(0.,1.) ), f - vec2(0.,1.) ), 
                                         dot( hash( i + vec2(1.,1.) ), f - vec2(1.,1.) ), u.x), u.y);
}

const int mode = 1;
vec2 gradient(vec2 loc) {
    float d = 0.01;
    vec2 base = 2.0 * loc + 0.3*vec2(itime, 2.0 * itime);
    if (mode == 1) {
        base = 4.0 * loc + 0.3*vec2(itime, 2.0 * itime);
    }

    float dx = (noise(base + vec2(d, 0.0)) - noise(base - vec2(d, 0.0))) / (2.0 * d);
    float dy = (noise(base + vec2(0.0, d)) - noise(base - vec2(0.0, d))) / (2.0 * d);

    return round(10.0*vec2(dy, -dx))/10.0; // curl
}

/////////////////////////////////////

// TRANSFORMATION SHADER
mat2 rot(float a)  {
    float c = cos(a);
    float s = sin(a);
    return mat2(c, s, -s, c);
}

const int ITERMAX = 8;

void curlnoise()
{
	vec2 uv = UV;
    vec2 uv2 = uv;
    uv -= vec2(0.5);
    
    //uv = rot((1.0+4.2*sin(1.3*iGlobalTime)) * 3.141 / 180.0) * uv;
    //uv *= 0.95;
    vec4 vg = vec4(0.0);
    vec2 qv = uv;
    for (int i = 0; i < ITERMAX; i++) {
        //qv += 0.001*gradient(qv + 0.1*vec2(iGlobalTime, iGlobalTime));
        qv += gradient(2.0 * qv) / iResolution;
        vg += texture(prevFrame, qv + vec2(0.5) + 0.0*0.01*vec2(0.4, -0.3)); // wind factor
    }
    color = (1.0 - curlweight) * texture(source, UV) + curlweight * vg / float(ITERMAX);
}


void main(){
	if (fx == 1) {
		blend();
	} else {
		curlnoise();
	}
}
