
#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; // = vec2(0.5);

// outputz
out vec4 fragColor;

float modp(inout vec2 p, float repetitions){
	float angle = 2.*3.14159/repetitions;
	float a = atan(p.y, p.x) + angle/2.;
	float r = length(p);
	float c = floor(a/angle);
	a = mod(a,angle) - angle/2.;
	p = vec2(cos(a), sin(a))*r;
	if (abs(c) >= (repetitions/2.)) c = abs(c);
	return c;
}

#define E 0.005
#define FAR 30.0
#define STEPS 70
float t;

#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)
float h4(vec4 p4)
{
	p4 = fract(p4  * HASHSCALE4);
    p4 += dot(p4, p4.wzxy+19.19);
    return dot(fract((p4.xxyz+p4.yzzw)*p4.zywx), vec4(1));
}

float impulse( float k, float x){
    float h = k*x;
    return h*exp(1.0-h);
}

mat3 rx(float a){return mat3(1.0,0.0,0.0,0.0,cos(a),-sin(a),0.0,sin(a),cos(a));}
mat3 ry(float a){return mat3(cos(a),0,sin(a),0.0,1.0,0.0,-sin(a),0.0,cos(a));}
mat3 rz(float a){return mat3(cos(a),-sin(a),0.0,sin(a),cos(a),0.0,0.0,0.0,1.0);}

float nrand(vec2 n){
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float n1rand(vec2 n){
	float t = fract( iGlobalTime );
	float nrnd0 = nrand( n + 0.07*t );
	return nrnd0;
}
float n2rand(vec2 n){
	float t = fract( iGlobalTime );
	float nrnd0 = nrand( n + 0.07*t );
	float nrnd1 = nrand( n + 0.11*t );
	return (nrnd0+nrnd1) / 2.0;
}

float sphere(vec3 p, float r){
    return length(p)-r;
}

vec2 mod2(inout vec2 p, vec2 size) {
	vec2 c = floor((p + size*0.5)/size);
	p = mod(p + size*0.5,size) - size*0.5;
	return c;
}

void rot(inout vec2 p, float a) {
	p = cos(a)*p + sin(a)*vec2(p.y, -p.x);
}

float smin(float a, float b, float r){
	vec2 u = max(vec2(r - a,r - b), vec2(0));
	return max(r, min (a, b)) - length(u);
}

float cv;
float r;

float pn(vec3 p) {
    vec3 i = floor(p); 
	vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.141592653589793)*(-.5) + .5;  
	a = mix(sin(cos(a)*a), sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y);   
	return mix(a.x, a.y, f.z);
}

float d4(vec4 x)
{
    vec4 i = round(x);
    vec4 f = fract(x);
    return mix(h4(i), h4(i+1.0), smoothstep(0.0, 1.0, length(f) ) );
}

float gm(vec3 p)
{
    if(iGlobalTime < 17.777777) return 9999.;
    return sphere(p, 1.5);
}

float map(vec3 p){
    vec3 op = p+vec3(0,0,0);
    float f = p.y+0.25;
    //p.yz += vec2(-0.25, 0.0);
    //mod2(p.xz, vec2(3) );
    float dd = 1e8;
    //for(int i = 0; i < 15; i++){
        p = op;
		float beat = 0.0;//0.012*impulse(12.0,mod(t,0.5))*smoothstep(18.,40.,t);
    	rot(p.yz, 3.14159265359*t*0.002);
    	float i1 = modp(p.xy, r);//*(0.5+0.5*sin(t*0.71)) );//rot(p.yz, float(i));
    	float i2 = modp(p.xz, r);//*(0.5+0.5*cos(t*0.61)));
    	
    	
    	//float s = sphere(p-vec3(2.0+4.0*(nrand(vec2(i1,i2))) ,0,0), 1.0+(0.05-r*0.002)*d4(vec4(p*8.0*min(1.0, 20.0/r ), i1*i2)));
    float s = sphere(p-vec3(2.0+4.0*(nrand(vec2(i1,i2))) ,0,0), 1.0+0.05*d4(vec4(p*8.0, i1*i2)));
    s = min(s, gm(op));
        //dd = smin(dd, s, 0.10);
        
    //}
    
    //float fs = smin(f,s, 0.05);
    
    return s;
}

vec3 normal( in vec3 p ){
    const float eps = 0.005;
    float d=map(p);
	return normalize(vec3(map(p+vec3(eps,0,0))-d,map(p+vec3(0,eps,0))-d,map(p+vec3(0,0,eps))-d));
}

float err(float dist){
    dist = dist/100.0;
    return min(E, dist*dist);
}

vec3 discontinuity_reduction(vec3 origin, vec3 direction, vec3 position){
    const int iterations = 4;
    for(int i = 0; i < iterations; i++){
        //float d = ;
        //position = position + direction * (geometry(position) - err(distance(origin, position)));
        position = position + direction * (map(position) - err(distance(origin, position)));
    }
    return position;
}

vec3 intersect(inout vec3 o, inout vec3 d, out vec3 no){
    float st = 0.0;
    float l = 0.0;
    float s = 0.0;
    for(int i = 0; i < STEPS; ++i){
		s = map(o+d*l);
		l += s;
        if(s < E || l > FAR) break;
    }
    //l = min(FAR, l);
    vec3 i = o+d*l;
    
    i = discontinuity_reduction(o, d, i);
    
    no = normal(i);
    o = i+0.15*no;
    d = reflect(d, no);
    return i;
}

float shadow(vec3 ro, vec3 rd, float mint, float tmax, float k){
	float res = 1.0;
    float t = mint;
    for( int i=0; i<50; i++){
		float h = map(ro + rd*t);
        res = min( res, k*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

float G1V(float dnv, float k){
    return 1.0/(dnv*(1.0-k)+k);
}

float ggx(vec3 n, vec3 v, vec3 l, float rough, float f0){
    float alpha = rough*rough;
    vec3 h = normalize(v+l);
    float dnl = clamp(dot(n,l), 0.0, 1.0);
    float dnv = clamp(dot(n,v), 0.0, 1.0);
    float dnh = clamp(dot(n,h), 0.0, 1.0);
    float dlh = clamp(dot(l,h), 0.0, 1.0);
    float f, d, vis;
    float asqr = alpha*alpha;
    const float pi = 3.14159;
    float den = dnh*dnh*(asqr-1.0)+1.0;
    d = asqr/(pi * den * den);
    dlh = pow(1.0-dlh, 5.0);
    f = f0 + (1.0-f0)*dlh;
    float k = alpha/1.0;
    vis = G1V(dnl, k)*G1V(dnv, k);
    float spec = dnl * d * f * vis;
    return spec;
}

float ao(vec3 spoint, vec3 norm){
    float ao = 1.0;
	float occlusion = 0.;
	float factor = 1.0;
	for(int i = 0; i < 5; ++i){
		spoint += .075*norm;
		occlusion += max(0.0, map(spoint)*factor);
		factor *= 0.75;
	}
    return clamp(occlusion, 0.0, 1.0);
}

//vec3 light = vec3(12.-24.*iMouse.x/iResolution.x,11.0,12.-24.*iMouse.y/iResolution.y);
vec3 light;
vec3 shade(vec3 p, vec3 o, vec3 d, vec3 normal, vec3 op){
    float bg = 0.0005;
    //if(iMouse.z > 0.0) bg = 0.1;
    if(distance(p, op) >= FAR) return vec3(bg);
    float s = 0.0;
    vec3 ld = normalize(mix(-normalize(p+light), -normalize(p-light), smoothstep(0.0,7.0,t))) ;
    //return abs(ld);
    
    s = ggx(normal, -d , ld, 0.95, 0.5);
    float fresnel = pow( 1.0+dot(normal, -d), 5.0 );
    fresnel = 0.2*pow((min(1.0, fresnel)),2.0);
    //s += fresnel;
    
    float amb = 0.4+0.6*ao(p, normal);
    
    //float ss = 0.1+0.9*shadow(p, ld)+0.1*n2rand( vec2(dot(p.x,p.z), p.y) );
    float ss = shadow(p, ld, 0.1, 15.0, 1.5);
    //return vec3(ss);
    s *= ss;
    
    
    return amb*mix(vec3(s)+0.5*pow(smoothstep(8.0,15.0,t ),2.0)*vec3(0.3,0.12,0.04).rbg*pow(1.0/(0.15+gm(p)), 1.6), vec3(bg), pow( clamp(distance(o+10.0*d, p)/(FAR*0.5), 0.0, 1.0), 2.0) );
}

float fresnel(vec3 p, vec3 d, vec3 n, float i1, float i2){
    vec3 ha = normalize(mix(normalize(p-light), d, 0.5));
    float cost = dot(d, ha);
    float f0 = pow((i1-i2)/(i1+i2), 2.0);
    float F = f0 + (1.0 + f0) * pow(1.0-acos(cost), 5.0);
    return F;
}
/*
float fresnel(vec3 p, vec3 d, vec3 c, vec3 n, float i1, float i2){
    vec3 ha = normalize(normalize(p-light)+d);
    float f0 = 0.8;
    float VdotH = max(dot(d, ha), 0.0);
    float fresnel = pow(1.0 - VdotH, 5.0);
    fresnel *= 1.0 - f0;
    return fresnel;
}
*/
void main()
{
    t = iGlobalTime*0.45;
    light = 0.75*vec3(9.-18.*sin(-t*0.41),9.-18.*cos(-t*0.31),9.-18.*sin(t*0.51));
    cv = 0.0;//smoothstep(108.,110.,t);//10.*sqrt(t);
    r = t+10000.0*cv;
    
	vec2 uv = -1.0+2.0*vec2(UV.x, UV.y*(576.0/1024.0)); //fragCoord.xy / iResolution.xx;
	vec2 r = iResolution.xy;
    //uv.y *= r.y/r.x;
    //mat3 rot = rx(0.5*3.141-3.141*iMouse.y/r.y)*ry( 2.0*(3.141-3.141*iMouse.x/r.x) );
    mat3 rot = rx(0.5*3.141-3.141*0.5)*ry( 2.0*(3.141*0.25) );
    vec3 o = vec3(8.0+4.0*smoothstep(0.0, 1.0, t*0.1),1.75+1.6*smoothstep(5.0, -1.0, t),0);
    if(mod(t,13.) > 8.){
        rot = rx(0.5*3.141-3.141*0.5)*ry( 2.0*(3.141*0.5) );
    	o = vec3(0,1.75,12);
    }
    
    vec3 d = normalize(rot*vec3(uv,2.0+1.0*smoothstep(0.0, 1.0, t*0.1) ));
    vec3 c = vec3(0.0);
    
    vec3 normal = vec3(0);
    vec3 op = o;
    vec3 i = intersect(o, d, normal);
    float f = fresnel(i, d, normal, 4.0, 2.0);
    c = shade(i, o, d, normal, op);
    float w = distance(op,i)/FAR;
    
    //float vignette = 1.0 / (0.8 + 1.3*dot(uv, uv));
	float noise = .02*vec3(nrand(uv*t)).x;
    c = 0.0*noise+c;
    c = 10.0*clamp(c, 0.0, 20.0);
	//fragColor = vec4(shade(i, o, d, normal, op),w);
	
	 c = mix(c, vec3(dot(c, vec3(0.299, 0.587, 0.114) )), 0.5);
    fragColor = vec4(c,w);
}
