#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec2 iMouse; // = vec2(0.5);
uniform float camspeed_mult;

// outputz
out vec4 fragColor;

#define E 1e-3
#define FAR_CLIP 30.0
#define AO 2
#define STEPS 40
float time;
vec3 campos;

// various helper functions
float imp(float k,float x){return k*x*exp(1.0-k*x);}
// rotation matrixes
mat3 rx(float a){return mat3(1.0,0.0,0.0,0.0,cos(a),-sin(a),0.0,sin(a),cos(a));}
mat3 ry(float a){return mat3(cos(a),0,sin(a),0.0,1.0,0.0,-sin(a),0.0,cos(a));}
mat3 rz(float a){return mat3(cos(a),-sin(a),0.0,sin(a),cos(a),0.0,0.0,0.0,1.0);}
// white noise
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

// cheap but sufficient fake perlin noise
float no(vec3 x){
    vec3 p=floor(x);
    vec3 f=fract(x);

    f=f*f*(3.0-2.0*f);
    float n=p.x+p.y*57.0+113.0*p.z;
    return mix(mix(mix(hash(n),hash(n+1.0),f.x),
                mix(hash(n+57.0),hash(n+58.0),f.x),f.y),
            mix(mix(hash(n+113.0),hash(n+114.0),f.x),
                mix(hash(n+170.0),hash(n+171.0),f.x),f.y),f.z);
}

float subs(float a, float b){
    return max(-a, b);   
}

// join objects with iq's smooth minimum technique
float smin(float a, float b, float k){
    float h=clamp(.5+.5*(b-a)/k,0.0,1.0);
    return mix(b,a,h)-k*h*(1.0-h);
}

// join objects with a plane
float chamfer(float a, float b, float k){
    return min(min(a,b), (a-k+b) );
}

// join objects with a corner
float corner(float a, float b, float k){
    return max(min(a,b), -(a-(k+min(a,b))+b));
}

// join objects with a quarter circle
float join(float a, float b, float r){
    float m = min(a,b);
    if( a < r && b < r ){
        return min(m, r-sqrt( (a-r)*(a-r) + (b-r)*(b-r)) );
    }
    return m;
}

// join objects with an inverse quarter circle
float bulge(float a, float b, float r){
    float m = min(a,b);
    return min(m, (a*a - r*r+b*b)*sqrt(2.0));
}

// sphere distance field
float sp(vec3 p, float s){
    return length(p)-s;
}

// box distance field
float bx(vec3 p, vec3 b){
    return length(max(abs(p)-b,0.0));
}

// box with rounded corners
float rbx(vec3 p, vec3 b, float r){
    return length(max(abs(p)-b,0.0))-r;
}

// duh
float torus(vec3 p, vec2 t){
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float capsule(vec3 p, vec3 a, vec3 b, float r){
    vec3 pa = p - a, ba = b - a;
    float h = clamp(dot(pa,ba)/dot(ba,ba), 0.0, 1.0);
    return length(pa - ba*h) - r;
}

float cylinder(vec3 p, vec2 h){
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

// geometry of the scene, overall distance field
const vec2 DIVERSE = vec2(3.0);

float mysign(float x) {
    float s = sign(x);
    return s;// != 0.0 ? s : -1.0;
}

float func(vec3 pos, float i, float j) {
    float dist = 1e8;
    return min(dist, rbx( mod(pos - vec3(0.,j,0.) + vec3(2.0 * i, -2.0, -mysign(pos.z)*4.0 + 0.5*sin(i + j + 2.*time)),
                                       vec3(0.0, DIVERSE.x, 0.0)), 
                                  vec3(1.1), 0.05 ));
}

float blox(vec3 pos, float i, float j) {
    return func(pos, i, j);
}
vec3 lightpos;
//vec3 lightpos   = vec3(2.,250.*iMouse.y/iResolution.y,5.);
//vec3 lightpos   = vec3(-2.0+4.*sin(time*1.23),32.0,-2.+4.*cos(time*0.89));
//vec3 lightpos= vec3(0., 16., 0.);
//vec3 lightpos   = vec3(2.,-50.+mod(time*40.0,70.0),0.);
//vec3 lightpos   = vec3(2.,30,-3.);

vec3 ballcolor = 0.3*vec3(0.9,0.2,0.1);
float rb(vec3 r){
    return sp(r+vec3(1,2.+8.*iMouse.y,4.-8.*iMouse.x), 1.0);
}

float geometry(vec3 r){
    float pa = rb(r);
    r.y -= mod(time*4.5, 15.);
    // floor geometry
    //float f = 100.0;//bx( vec3(r.x+5.0, r.y-1.5, r.z+6.0), vec3(7.0,1.0,7.0) );
    float dist = 1e8;
    for (float j = 0.0; j < DIVERSE.y; j += 1.0) {
        for (float i = 0.0; i < DIVERSE.x; i += 1.0) {
            float blocka = blox(r, i, j);
            float blockb = blox(ry(90.*3.141/180.)*(r+vec3(2.0,0.0,2.0)), i, j);
            dist = min(dist, min(blocka, blockb));
        }
    }

    return min(dist, pa);
    //return dist;//min(dist, sp(lightpos, 0.1));
    //return corner(pyr, f, 0.5);
}

// calculate normal at a point
vec3 normal(vec3 p){
    // make smaller for more precision
    // 1e-2 tends to give nice softness though :)
    float e=5e-6;
    return normalize(vec3(geometry(p+vec3(e,0,0))-geometry(p-vec3(e,0,0)),
                          geometry(p+vec3(0,e,0))-geometry(p-vec3(0,e,0)),
                          geometry(p+vec3(0,0,e))-geometry(p-vec3(0,0,e))));
}

vec3 ldr(vec3 p){
    // make smaller for more precision
    // 1e-2 tends to give nice softness though :)
    float e=5e-6;
    return normalize(vec3(rb(p+vec3(e,0,0))-rb(p-vec3(e,0,0)),
                          rb(p+vec3(0,e,0))-rb(p-vec3(0,e,0)),
                          rb(p+vec3(0,0,e))-rb(p-vec3(0,0,e))));
}

float shadow(vec3 ro, vec3 rd, float mint, float tmax, float k){
    float res = 1.0;
    float t = mint;
    for( int i=0; i<20; i++){
        float h = geometry( ro + rd*t );
        res = min( res, k*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

float shadow_r(vec3 ro, vec3 rd, float mint, float tmax, float k){
    float res = 1.0;
    float t = mint;
    for( int i=0; i<10; i++){
        float h = geometry( ro + rd*t );
        res = min( res, k*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.005 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

float ao(vec3 spoint, vec3 norm){
    float ao = 1.0;
    float occlusion = 0.;
    float factor = 1.0;
    for(int i = 0; i < 5; ++i){
        spoint += .25*norm;
        occlusion += geometry(spoint)*factor;
        factor *= .6;
    }
    //return (ao)*(1.0-occlusion/ao);
    return clamp(occlusion, 0.0, 1.0);
    //return clamp((ao*2.0)*(1.0-occlusion/ao), 0.0, 1.0);
}

// global because this may be used elsewhere too

vec3 fogcolor    = 1.75*vec3(.43,.61,.52);
vec3 shade(vec3 point, float dist){
    vec3 norm = normal(point);
    vec3 lvec = -(point+lightpos);
    vec3 lightdir   = normalize(lvec);
    float bgi = 8.0/max(0.1, pow(rb(point),2.0));
    //bgi *= abs(dot(norm, ldr(point)));
    float intensity = max(0.0, dot(lightdir, norm) );

    float shadows   = bgi+0.1+0.9*shadow(point+lightdir*0.1, lightdir, .05, 10.0, 4.0);
    vec3 lightcolor  = mix(vec3(.91,.84,.73), ballcolor, bgi*0.1);
    vec3 shadowcolor = vec3(1)-lightcolor;
    vec3 amb = vec3(ao(point, norm) );
    //return ballcolor*bgi+amb;
    
    lightcolor += 8.0*pow(max(dot(normalize(lightdir),norm),0.0),10.0);
    return ballcolor*bgi+mix( lightcolor*intensity * mix(shadowcolor, vec3(1.0), shadows) * amb, fogcolor/0.8, pow(dist/float(FAR_CLIP), 1.0));
}

vec3 shade_r(vec3 point, float dist){
    vec3 norm = normal(point);
    vec3 lvec = -(point+lightpos);
    vec3 lightdir   = normalize(lvec);
    float bgi = 8.0/max(0.1, pow(rb(point),2.0));
    //bgi *= abs(dot(norm, ldr(point)));
    float intensity = max(0.0, dot(lightdir, norm) );

    float shadows   = bgi+0.1+0.9*shadow_r(point+lightdir*0.1, lightdir, .05, 10.0, 4.0);
    vec3 lightcolor  = mix(vec3(.91,.84,.73), ballcolor, bgi*0.1);
    vec3 shadowcolor = vec3(1)-lightcolor;
    vec3 amb = vec3(ao(point, norm) );
    
    lightcolor += 10.0*pow(max(dot(normalize(lightdir),norm),0.0),10.0);
    return ballcolor*bgi+mix( lightcolor*intensity * mix(shadowcolor, vec3(1.0), shadows) * amb, fogcolor/0.8, pow(dist/float(FAR_CLIP), 1.0));
}

float err(float dist){
    dist = dist/100.0;
    return min(E, dist*dist);
}

vec3 discontinuity_reduction(vec3 origin, vec3 direction, vec3 position){
    const int iterations = 3;
    for(int i = 0; i < iterations; i++){
        //float d = ;
        //position = position + direction * (geometry(position) - err(distance(origin, position)));
        position = position + direction * (geometry(position) - err(distance(origin, position)));
    }
    return position;
}
/*
vec3 refl2(vec3 origin, vec3 direction){
    vec3 position = vec3(0.0);
    float distance = 0.0;
    float length = 0.0;
    float glow = 0.0;
    for(int i=0; i < 25; ++i){
        position = origin + direction * length;
        distance = geometry(position);
        length  += distance;
        if(float(FAR_CLIP) < length || distance < E) break;
    }
    if(float(FAR_CLIP) < length) return fogcolor;
    return shade_r(position, length);
}
*/
vec3 refl(vec3 origin, vec3 direction){
    vec3 position = vec3(0.0);
    float distance = 0.0;
    float length = 0.0;
    float glow = 0.0;
    for(int i=0; i < 30; ++i){
        position = origin + direction * length;
        distance = geometry(position);
        length  += distance;
        if(float(FAR_CLIP) < length || distance < E) break;
    }
    if(float(FAR_CLIP) < length) return 2.*fogcolor;
    vec3 norm = normal(position);
    //return 0.3*refl2(position+0.01*norm, reflect(direction, norm)) + 0.7*shade(position, length);
    return shade_r(position, length);
}

float fresnel(vec3 p, vec3 d, vec3 n, float i1, float i2){
    vec3 ha = normalize(mix(normalize(p-campos), d, 0.0));
    float cost = dot(d, ha);
    float f0 = pow((i1-i2)/(i1+i2), 2.0);
    float F = f0 + (1.0 + f0) * pow(1.0-acos(cost), 5.0);
    return max(0.0, F);
}
/*
bool intersect_sphere(vec3 ap, vec3 bp, vec3 cp, float r){
    float a = pow(bp.x-ap.x, 2.0)+pow(bp.y-ap.y, 2.0)+pow(bp.z-ap.z, 2.0);
    float b = 2.0*((bp.x-ap.x)*(ap.x-cp.x)+(bp.y-ap.y)*(ap.y-cp.y)+(bp.z-ap.z)*(ap.z-cp.z));
    float c = pow(ap.x-cp.x, 2.0)+pow(ap.y-cp.y, 2.0)+pow(ap.z-cp.z, 2.0)-r*r;
    float delta = b*b-4.0*a*c;
    return (delta > 0.0);
}
*/
vec3 march(vec3 origin, vec3 direction, inout float depth){
    vec3 position = vec3(0.0);
    float dist = 0.0;
    float length = 0.0;
    float glow = 0.0;
    for(int i=0; i < STEPS; ++i){
        position = origin + direction * length;
        dist = geometry(position);
        length  += dist;
        //if(intersect_sphere(origin,position,lightpos, 0.5)) return vec3(1.0);
        if(float(FAR_CLIP) < length || dist < E) break;
    }
    length = min(FAR_CLIP, length);
    depth = min(1.0, length/FAR_CLIP);
    if(float(FAR_CLIP) <= length) return 1.3*fogcolor;
    position = discontinuity_reduction(origin, direction, position);
    
    vec3 norm = normal(position);
    float fr = pow(fresnel(position, reflect(direction, norm), norm, 2.0, 2.0), 0.25);
    vec3 refc = min(1.0, 0.5+fr)*refl(position+0.01*norm, reflect(direction, norm));
    return refc+0.5*shade(position, length);
}

vec3 correct(vec3 c){
    c = c*1.1-0.05;
    c = smoothstep(.1, .8, c);
    c.z = .03+pow(c.z, 1.3)*1.2;
    c.x = pow(c.x,.8);
    return .07+1.8*c;
}

void main(){
    time = 0.8*iGlobalTime;
    lightpos = vec3(4.*sin(time*1.23),20.,2.*cos(time*0.89));
    vec2 r = iResolution.xy;
    vec2 p = 1.-2.*UV;
    p.y *= r.y/r.x;

    // camera setup
    mat3 angle     = rx(-.25)*ry(2.0)*rz(.06);
    mat3 rotation  = ry(-90.0*3.141/180.0)*rx(90.*3.141/180.)*ry(camspeed_mult*2.0*time*3.141/180.); // rz(0.5*3.141-3.141*iMouse.y/r.y)*ry( 2.0*(3.141-3.141*iMouse.x/r.x) );
    vec3 camera    = vec3(-2.0, 0.0, 1.0);
    vec3 direction = normalize(vec3(p, 1.0)*angle*rotation);
    campos = camera;
    
    // render visuals
    float depth;
    vec3 color = march(camera, direction, depth);
    
    // correct, post and output
    //color = correct(color);
    //color = mix(color, 0.6*vec3(pow(length(color),1.4)), 0.0);
    
    //color = pow(color, vec3(1.0/2.2));
    //color = vec3(length(color));
    float vignette = 1.0 / (.8 + 1.3*dot(p, p));
    float noise = .02*vec3(hash(length(p)*time)).x;
    color = vec3(dot(color.rgb, vec3(0.299, 0.587, 0.114)));
    color = smoothstep(0.2, 1.1, color);
    fragColor = vec4(clamp(noise+color*vignette, 0.0, 2.0), depth);
}