#version 330 core

in vec2 UV;
out vec4 fragColor;

// The input scenes
uniform sampler2D textuA;
uniform sampler2D textuB;

// Blending textures
uniform sampler2D eskoA;
uniform sampler2D eskoB;
uniform sampler2D eskoC;
uniform int kuva;

void main() {
	float w = 0.0;
	if (kuva == 0) {
		w = texture(eskoA, UV).x;
	} else if (kuva == 1) {
		w = texture(eskoB, UV).x;
	} else {
		w = texture(eskoC, UV).x;
	}
	w = (w >= 0.5) ? 1.0 : 0.0;
    fragColor =        w  * texture(textuA, UV)
              + (1.0 - w) * texture(textuB, UV);
}
