#version 330 core

in vec2 UV;
uniform sampler2D colors;
uniform sampler2D normals;
uniform sampler2D ssao;
uniform sampler2D depth;
uniform sampler2D refls;
uniform mat4 projection; // should be viewprojection
uniform mat4 depthMVP;
uniform vec3 lightpos;
uniform vec3 eyepos;
uniform sampler2D volushadows;

uniform float ambientCoeff; // = 1.0;
uniform float diffuCoeff; // = 0.5;
const float specuCoeff = 1.4;
uniform int useSmaps;

// outputz
out vec4 color;


// Transform UV from location texture to (x, y, z) world coordinates
vec3 getPos(vec2 uv) {
  float z = 2.0 * texture(depth, uv).x - 1.0;
  vec4 clipSpace = vec4(2.0*UV-1.0, z, 1.0);
  vec4 homogLoc = inverse(projection) * clipSpace;
  return homogLoc.xyz / homogLoc.w;
}

void main() {
    // Extract data from helper buffers
    vec4 cAmbient = vec4(smoothstep( vec3(0.0), vec3(ambientCoeff), texture(ssao, UV).rgb ) * texture(colors, UV).rgb, 1.0);  // Ambient color
    vec4 normalData = texture(normals, UV);                                      // Surface normal

    // Lambertian light stuff
    vec3 normal = normalize(texture(normals, UV).xyz);
    vec3 pixpos = getPos(UV);
    vec3 lightdir = normalize(pixpos - lightpos);
    float lambertTerm = max(0.0, dot(normal, lightdir));
    vec4 cLambert = vec4(lambertTerm * vec3(0.9, 1.0, 1.0), 1.0);

    // Specular term
    vec4 cSpecular = vec4(0.0);

    // Visibility calculation
    vec4 lightCoord = depthMVP * vec4(pixpos, 1.0);
    vec2 pixUV = lightCoord.xy / lightCoord.w;
    float visib = (useSmaps > 0) ? texture(volushadows, UV).x : 1.0;

    // Light fusion
    color = visib * (cAmbient
          + visib * (
              diffuCoeff * cLambert
            + specuCoeff * cSpecular
            ));
    float metalMask = 0.5;
    vec3 baseColor = cAmbient.xyz;
    vec4 rd = texture(refls, UV);
    color.a = 1.0;
}
